/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.metrics.ServerQueryPhase;
import org.apache.pinot.common.metrics.ServerTimer;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.core.query.request.ServerQueryRequest;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceRequestHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceRequestHandler.class);
    private static final int SLOW_QUERY_LATENCY_THRESHOLD_MS = 100;
    private final TDeserializer _deserializer = new TDeserializer((TProtocolFactory)new TCompactProtocol.Factory());
    private final QueryScheduler _queryScheduler;
    private final ServerMetrics _serverMetrics;

    public InstanceRequestHandler(QueryScheduler queryScheduler, ServerMetrics serverMetrics) {
        this._queryScheduler = queryScheduler;
        this._serverMetrics = serverMetrics;
    }

    protected void channelRead0(final ChannelHandlerContext ctx, ByteBuf msg) {
        final long queryArrivalTimeMs = System.currentTimeMillis();
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.QUERIES, 1L);
        int requestSize = msg.readableBytes();
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NETTY_CONNECTION_BYTES_RECEIVED, (long)requestSize);
        byte[] requestBytes = new byte[requestSize];
        msg.readBytes(requestBytes);
        InstanceRequest instanceRequest = new InstanceRequest();
        try {
            this._deserializer.deserialize((TBase)instanceRequest, requestBytes);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while deserializing the instance request: {}", (Object)BytesUtils.toHexString((byte[])requestBytes), (Object)e);
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REQUEST_DESERIALIZATION_EXCEPTIONS, 1L);
            return;
        }
        ServerQueryRequest queryRequest = new ServerQueryRequest(instanceRequest, this._serverMetrics, queryArrivalTimeMs);
        queryRequest.getTimerContext().startNewPhaseTimer(ServerQueryPhase.REQUEST_DESERIALIZATION, queryArrivalTimeMs).stopAndRecord();
        Futures.addCallback(this._queryScheduler.submit(queryRequest), (FutureCallback)new FutureCallback<byte[]>(){

            public void onSuccess(@Nullable byte[] responseBytes) {
                if (responseBytes != null) {
                    long sendResponseStartTimeMs = System.currentTimeMillis();
                    int queryProcessingTimeMs = (int)(sendResponseStartTimeMs - queryArrivalTimeMs);
                    ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])responseBytes)).addListener(f -> {
                        long sendResponseEndTimeMs = System.currentTimeMillis();
                        int sendResponseLatencyMs = (int)(sendResponseEndTimeMs - sendResponseStartTimeMs);
                        InstanceRequestHandler.this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NETTY_CONNECTION_RESPONSES_SENT, 1L);
                        InstanceRequestHandler.this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.NETTY_CONNECTION_BYTES_SENT, (long)responseBytes.length);
                        InstanceRequestHandler.this._serverMetrics.addTimedValue((AbstractMetrics.Timer)ServerTimer.NETTY_CONNECTION_SEND_RESPONSE_LATENCY, (long)sendResponseLatencyMs, TimeUnit.MILLISECONDS);
                        int totalQueryTimeMs = (int)(sendResponseEndTimeMs - queryArrivalTimeMs);
                        if (totalQueryTimeMs > 100) {
                            LOGGER.info("Slow query: request handler processing time: {}, send response latency: {}, total time to handle request: {}", new Object[]{queryProcessingTimeMs, sendResponseLatencyMs, totalQueryTimeMs});
                        }
                    });
                }
            }

            public void onFailure(Throwable t) {
                LOGGER.error("Caught exception while processing instance request", t);
                InstanceRequestHandler.this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.UNCAUGHT_EXCEPTIONS, 1L);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("Caught exception while fetching instance request", cause);
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.REQUEST_FETCH_EXCEPTIONS, 1L);
    }
}

