/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.v2.store;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.data.aggregator.ValueAggregatorFactory;
import org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.index.readers.forward.BaseChunkSVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.FixedBitSVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.startree.OffHeapStarTree;
import org.apache.pinot.core.startree.StarTree;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.core.startree.v2.StarTreeV2;
import org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.core.startree.v2.store.StarTreeDataSource;
import org.apache.pinot.core.startree.v2.store.StarTreeIndexMapUtils;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;

public class StarTreeLoaderUtils {
    private StarTreeLoaderUtils() {
    }

    public static List<StarTreeV2> loadStarTreeV2(PinotDataBuffer dataBuffer, List<Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>> indexMapList, SegmentMetadataImpl segmentMetadata, Map<String, ColumnIndexContainer> indexContainerMap) {
        List<StarTreeV2Metadata> starTreeMetadataList = segmentMetadata.getStarTreeV2MetadataList();
        int numStarTrees = starTreeMetadataList.size();
        ArrayList<StarTreeV2> starTrees = new ArrayList<StarTreeV2>(numStarTrees);
        for (int i = 0; i < numStarTrees; ++i) {
            Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> indexMap = indexMapList.get(i);
            StarTreeIndexMapUtils.IndexValue indexValue = indexMap.get(StarTreeIndexMapUtils.STAR_TREE_INDEX_KEY);
            long start = indexValue._offset;
            long end = start + indexValue._size;
            final OffHeapStarTree starTree = new OffHeapStarTree(dataBuffer.view(start, end, ByteOrder.LITTLE_ENDIAN));
            final StarTreeV2Metadata starTreeMetadata = starTreeMetadataList.get(i);
            int numDocs = starTreeMetadata.getNumDocs();
            final HashMap<String, StarTreeDataSource> dataSourceMap = new HashMap<String, StarTreeDataSource>();
            for (String dimension : starTreeMetadata.getDimensionsSplitOrder()) {
                indexValue = indexMap.get(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, dimension));
                start = indexValue._offset;
                end = start + indexValue._size;
                PinotDataBuffer forwardIndexDataBuffer = dataBuffer.view(start, end, ByteOrder.BIG_ENDIAN);
                ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(dimension);
                FixedBitSVForwardIndexReader forwardIndex = new FixedBitSVForwardIndexReader(forwardIndexDataBuffer, numDocs, columnMetadata.getBitsPerElement());
                dataSourceMap.put(dimension, new StarTreeDataSource(columnMetadata.getFieldSpec(), numDocs, forwardIndex, indexContainerMap.get(dimension).getDictionary()));
            }
            for (AggregationFunctionColumnPair functionColumnPair : starTreeMetadata.getFunctionColumnPairs()) {
                String metric = functionColumnPair.toColumnName();
                indexValue = indexMap.get(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, metric));
                start = indexValue._offset;
                end = start + indexValue._size;
                PinotDataBuffer forwardIndexDataBuffer = dataBuffer.view(start, end, ByteOrder.BIG_ENDIAN);
                FieldSpec.DataType dataType = ValueAggregatorFactory.getAggregatedValueType(functionColumnPair.getFunctionType());
                MetricFieldSpec fieldSpec = new MetricFieldSpec(metric, dataType);
                BaseChunkSVForwardIndexReader forwardIndex = dataType == FieldSpec.DataType.BYTES ? new VarByteChunkSVForwardIndexReader(forwardIndexDataBuffer, FieldSpec.DataType.BYTES) : new FixedByteChunkSVForwardIndexReader(forwardIndexDataBuffer, dataType);
                dataSourceMap.put(metric, new StarTreeDataSource((FieldSpec)fieldSpec, numDocs, forwardIndex, null));
            }
            starTrees.add(new StarTreeV2(){

                @Override
                public StarTree getStarTree() {
                    return starTree;
                }

                @Override
                public StarTreeV2Metadata getMetadata() {
                    return starTreeMetadata;
                }

                @Override
                public DataSource getDataSource(String columnName) {
                    return (DataSource)dataSourceMap.get(columnName);
                }

                @Override
                public void close() throws IOException {
                    for (DataSource dataSource : dataSourceMap.values()) {
                        dataSource.getForwardIndex().close();
                    }
                }
            });
        }
        return starTrees;
    }
}

