/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.v2.store;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;

public class StarTreeIndexMapUtils {
    public static final IndexKey STAR_TREE_INDEX_KEY = new IndexKey(IndexType.STAR_TREE, null);
    private static final String OFFSET_SUFFIX = "OFFSET";
    private static final String SIZE_SUFFIX = "SIZE";

    private StarTreeIndexMapUtils() {
    }

    public static void storeToFile(List<Map<IndexKey, IndexValue>> indexMaps, File indexMapFile) throws ConfigurationException {
        Preconditions.checkState((!indexMapFile.exists() ? 1 : 0) != 0, (Object)"Star-tree index map file already exists");
        PropertiesConfiguration configuration = new PropertiesConfiguration(indexMapFile);
        int numStarTrees = indexMaps.size();
        for (int i = 0; i < numStarTrees; ++i) {
            Map<IndexKey, IndexValue> indexMap = indexMaps.get(i);
            for (Map.Entry<IndexKey, IndexValue> entry : indexMap.entrySet()) {
                IndexKey key = entry.getKey();
                IndexValue value = entry.getValue();
                configuration.addProperty(key.getPropertyName(i, OFFSET_SUFFIX), (Object)value._offset);
                configuration.addProperty(key.getPropertyName(i, SIZE_SUFFIX), (Object)value._size);
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(configuration.getFile());){
            configuration.save((OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<IndexKey, IndexValue>> loadFromFile(File indexMapFile, int numStarTrees) throws ConfigurationException {
        Preconditions.checkState((boolean)indexMapFile.exists(), (Object)"Star-tree index map file does not exist");
        PropertiesConfiguration configuration = CommonsConfigurationUtils.fromFile((File)indexMapFile);
        List<Map<IndexKey, IndexValue>> indexMaps = IntStream.range(0, numStarTrees).boxed().map(index -> new HashMap()).collect(Collectors.toList());
        for (String key : CommonsConfigurationUtils.getKeys((Configuration)configuration)) {
            String[] split = key.split("\\.");
            Preconditions.checkState((split.length == 4 ? 1 : 0) != 0, (Object)("Invalid key: " + key + " in star-tree index map file: " + indexMapFile.getAbsolutePath()));
            int starTreeId = Integer.parseInt(split[0]);
            Map<IndexKey, IndexValue> indexMap = indexMaps.get(starTreeId);
            IndexType indexType = IndexType.valueOf(split[2]);
            IndexKey indexKey = indexType == IndexType.STAR_TREE ? STAR_TREE_INDEX_KEY : new IndexKey(IndexType.FORWARD_INDEX, split[1]);
            IndexValue indexValue = indexMap.computeIfAbsent(indexKey, k -> new IndexValue());
            long value = configuration.getLong(key);
            if (split[3].equals(OFFSET_SUFFIX)) {
                indexValue._offset = value;
                continue;
            }
            indexValue._size = value;
        }
        return indexMaps;
    }

    public static class IndexValue
    implements Comparable<IndexValue> {
        public long _offset;
        public long _size;

        public IndexValue() {
        }

        public IndexValue(long offset, long size) {
            this._offset = offset;
            this._size = size;
        }

        @Override
        public int compareTo(@Nonnull IndexValue o) {
            return Long.compare(this._offset, o._offset);
        }
    }

    public static class IndexKey {
        public final IndexType _indexType;
        public final String _column;

        public IndexKey(IndexType indexType, @Nullable String column) {
            this._indexType = indexType;
            this._column = column;
        }

        public String getPropertyName(int starTreeId, String suffix) {
            return String.format("%d.%s.%s.%s", new Object[]{starTreeId, this._column, this._indexType, suffix});
        }

        public int hashCode() {
            return 31 * this._indexType.hashCode() + Objects.hashCode(this._column);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof IndexKey) {
                IndexKey that = (IndexKey)obj;
                return this._indexType == that._indexType && Objects.equals(this._column, that._column);
            }
            return false;
        }
    }

    public static enum IndexType {
        STAR_TREE,
        FORWARD_INDEX;

    }
}

