/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.v2.builder;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.core.startree.v2.store.StarTreeIndexMapUtils;

public class StarTreeIndexCombiner
implements Closeable {
    private final FileChannel _fileChannel;

    public StarTreeIndexCombiner(File indexFile) throws IOException {
        Preconditions.checkState((!indexFile.exists() ? 1 : 0) != 0, (Object)"Star-tree index file already exists");
        this._fileChannel = new RandomAccessFile(indexFile, "rw").getChannel();
    }

    public Map<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> combine(StarTreeV2BuilderConfig builderConfig, File starTreeIndexDir) throws IOException {
        HashMap<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue> indexMap = new HashMap<StarTreeIndexMapUtils.IndexKey, StarTreeIndexMapUtils.IndexValue>();
        File starTreeIndexFile = new File(starTreeIndexDir, "star_tree.index");
        indexMap.put(StarTreeIndexMapUtils.STAR_TREE_INDEX_KEY, this.writeFile(starTreeIndexFile));
        for (String dimension : builderConfig.getDimensionsSplitOrder()) {
            File dimensionIndexFile = new File(starTreeIndexDir, dimension + ".sv.unsorted.fwd");
            indexMap.put(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, dimension), this.writeFile(dimensionIndexFile));
        }
        for (AggregationFunctionColumnPair functionColumnPair : builderConfig.getFunctionColumnPairs()) {
            String metric = functionColumnPair.toColumnName();
            File metricIndexFile = new File(starTreeIndexDir, metric + ".sv.raw.fwd");
            indexMap.put(new StarTreeIndexMapUtils.IndexKey(StarTreeIndexMapUtils.IndexType.FORWARD_INDEX, metric), this.writeFile(metricIndexFile));
        }
        org.apache.commons.io.FileUtils.cleanDirectory((File)starTreeIndexDir);
        return indexMap;
    }

    private StarTreeIndexMapUtils.IndexValue writeFile(File srcFile) throws IOException {
        try (FileChannel src = new RandomAccessFile(srcFile, "r").getChannel();){
            long offset = this._fileChannel.position();
            long size = src.size();
            FileUtils.transferBytes((FileChannel)src, (long)0L, (long)size, (FileChannel)this._fileChannel);
            StarTreeIndexMapUtils.IndexValue indexValue = new StarTreeIndexMapUtils.IndexValue(offset, size);
            return indexValue;
        }
    }

    @Override
    public void close() throws IOException {
        this._fileChannel.close();
    }
}

