/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.v2;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;

public class StarTreeV2Metadata {
    private final int _numDocs;
    private final List<String> _dimensionsSplitOrder;
    private final Set<AggregationFunctionColumnPair> _functionColumnPairs;
    private final int _maxLeafRecords;
    private final Set<String> _skipStarNodeCreationForDimensions;

    public StarTreeV2Metadata(Configuration metadataProperties) {
        this._numDocs = metadataProperties.getInt("total.docs");
        this._dimensionsSplitOrder = Arrays.asList(metadataProperties.getStringArray("split.order"));
        this._functionColumnPairs = new HashSet<AggregationFunctionColumnPair>();
        for (String functionColumnPair : metadataProperties.getStringArray("function.column.pairs")) {
            this._functionColumnPairs.add(AggregationFunctionColumnPair.fromColumnName(functionColumnPair));
        }
        this._maxLeafRecords = metadataProperties.getInt("max.leaf.records");
        this._skipStarNodeCreationForDimensions = new HashSet<String>(Arrays.asList(metadataProperties.getStringArray("skip.star.node.creation")));
    }

    public int getNumDocs() {
        return this._numDocs;
    }

    public List<String> getDimensionsSplitOrder() {
        return this._dimensionsSplitOrder;
    }

    public Set<AggregationFunctionColumnPair> getFunctionColumnPairs() {
        return this._functionColumnPairs;
    }

    public boolean containsFunctionColumnPair(AggregationFunctionColumnPair functionColumnPair) {
        return this._functionColumnPairs.contains(functionColumnPair);
    }

    public int getMaxLeafRecords() {
        return this._maxLeafRecords;
    }

    public Set<String> getSkipStarNodeCreationForDimensions() {
        return this._skipStarNodeCreationForDimensions;
    }
}

