/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree.executor;

import java.util.Map;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.aggregation.groupby.DefaultGroupByExecutor;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;

public class StarTreeGroupByExecutor
extends DefaultGroupByExecutor {
    private final AggregationFunctionColumnPair[] _aggregationFunctionColumnPairs;

    public StarTreeGroupByExecutor(AggregationFunction[] aggregationFunctions, ExpressionContext[] groupByExpressions, int maxInitialResultHolderCapacity, int numGroupsLimit, TransformOperator transformOperator) {
        super(aggregationFunctions, groupByExpressions, maxInitialResultHolderCapacity, numGroupsLimit, transformOperator);
        int numAggregationFunctions = aggregationFunctions.length;
        this._aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            this._aggregationFunctionColumnPairs[i] = AggregationFunctionUtils.getAggregationFunctionColumnPair(aggregationFunctions[i]);
        }
    }

    @Override
    protected void aggregate(TransformBlock transformBlock, int length, int functionIndex) {
        AggregationFunction aggregationFunction = this._aggregationFunctions[functionIndex];
        GroupByResultHolder groupByResultHolder = this._groupByResultHolders[functionIndex];
        Map<ExpressionContext, BlockValSet> blockValSetMap = AggregationFunctionUtils.getBlockValSetMap(this._aggregationFunctionColumnPairs[functionIndex], transformBlock);
        if (this._hasMVGroupByExpression) {
            aggregationFunction.aggregateGroupByMV(length, this._mvGroupKeys, groupByResultHolder, blockValSetMap);
        } else {
            aggregationFunction.aggregateGroupBySV(length, this._svGroupKeys, groupByResultHolder, blockValSetMap);
        }
    }
}

