/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.common.DataSource;
import org.apache.pinot.core.indexsegment.IndexSegment;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluatorProvider;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.query.request.context.ExpressionContext;
import org.apache.pinot.core.query.request.context.FilterContext;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.predicate.Predicate;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;

public class StarTreeUtils {
    public static final String USE_STAR_TREE_KEY = "useStarTree";

    private StarTreeUtils() {
    }

    public static boolean isStarTreeDisabled(QueryContext queryContext) {
        Map<String, String> debugOptions = queryContext.getDebugOptions();
        return debugOptions != null && "false".equalsIgnoreCase(debugOptions.get(USE_STAR_TREE_KEY));
    }

    @Nullable
    public static AggregationFunctionColumnPair[] extractAggregationFunctionPairs(AggregationFunction[] aggregationFunctions) {
        int numAggregationFunctions = aggregationFunctions.length;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunctionColumnPair aggregationFunctionColumnPair = AggregationFunctionUtils.getAggregationFunctionColumnPair(aggregationFunctions[i]);
            if (aggregationFunctionColumnPair == null) {
                return null;
            }
            aggregationFunctionColumnPairs[i] = aggregationFunctionColumnPair;
        }
        return aggregationFunctionColumnPairs;
    }

    @Nullable
    public static Map<String, List<PredicateEvaluator>> extractPredicateEvaluatorsMap(IndexSegment indexSegment, @Nullable FilterContext filter) {
        FilterContext filterNode;
        if (filter == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<PredicateEvaluator>> predicateEvaluatorsMap = new HashMap<String, List<PredicateEvaluator>>();
        LinkedList<FilterContext> queue = new LinkedList<FilterContext>();
        queue.add(filter);
        block8: while ((filterNode = (FilterContext)queue.poll()) != null) {
            switch (filterNode.getType()) {
                case AND: {
                    queue.addAll(filterNode.getChildren());
                    continue block8;
                }
                case OR: {
                    return null;
                }
                case PREDICATE: {
                    Predicate predicate = filterNode.getPredicate();
                    ExpressionContext lhs = predicate.getLhs();
                    if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) {
                        return null;
                    }
                    String column = lhs.getIdentifier();
                    DataSource dataSource = indexSegment.getDataSource(column);
                    Dictionary dictionary = dataSource.getDictionary();
                    if (dictionary == null) {
                        return null;
                    }
                    switch (predicate.getType()) {
                        case REGEXP_LIKE: 
                        case TEXT_MATCH: 
                        case IS_NULL: 
                        case IS_NOT_NULL: {
                            return null;
                        }
                    }
                    PredicateEvaluator predicateEvaluator = PredicateEvaluatorProvider.getPredicateEvaluator(predicate, dictionary, dataSource.getDataSourceMetadata().getDataType());
                    if (predicateEvaluator.isAlwaysFalse()) {
                        return null;
                    }
                    if (predicateEvaluator.isAlwaysTrue()) continue block8;
                    predicateEvaluatorsMap.computeIfAbsent(column, k -> new ArrayList()).add(predicateEvaluator);
                    continue block8;
                }
            }
            throw new IllegalStateException();
        }
        return predicateEvaluatorsMap;
    }

    public static boolean isFitForStarTree(StarTreeV2Metadata starTreeV2Metadata, AggregationFunctionColumnPair[] aggregationFunctionColumnPairs, @Nullable ExpressionContext[] groupByExpressions, Set<String> predicateColumns) {
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            if (starTreeV2Metadata.containsFunctionColumnPair(aggregationFunctionColumnPair)) continue;
            return false;
        }
        HashSet<String> starTreeDimensions = new HashSet<String>(starTreeV2Metadata.getDimensionsSplitOrder());
        if (groupByExpressions != null) {
            HashSet<String> groupByColumns = new HashSet<String>();
            for (ExpressionContext groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            if (!starTreeDimensions.containsAll(groupByColumns)) {
                return false;
            }
        }
        return starTreeDimensions.containsAll(predicateColumns);
    }

    public static boolean shouldRemoveExistingStarTrees(List<StarTreeV2BuilderConfig> builderConfigs, List<StarTreeV2Metadata> metadataList) {
        int numStarTrees = builderConfigs.size();
        if (metadataList.size() != numStarTrees) {
            return true;
        }
        for (int i = 0; i < numStarTrees; ++i) {
            StarTreeV2BuilderConfig builderConfig = builderConfigs.get(i);
            StarTreeV2Metadata metadata = metadataList.get(i);
            if (!builderConfig.getDimensionsSplitOrder().equals(metadata.getDimensionsSplitOrder())) {
                return true;
            }
            if (!builderConfig.getSkipStarNodeCreationForDimensions().equals(metadata.getSkipStarNodeCreationForDimensions())) {
                return true;
            }
            if (!builderConfig.getFunctionColumnPairs().equals(metadata.getFunctionColumnPairs())) {
                return true;
            }
            if (builderConfig.getMaxLeafRecords() == metadata.getMaxLeafRecords()) continue;
            return true;
        }
        return false;
    }

    public static void removeStarTrees(File indexDir) throws Exception {
        File segmentDirectory = SegmentDirectoryPaths.findSegmentDirectory(indexDir);
        PropertiesConfiguration metadataProperties = CommonsConfigurationUtils.fromFile((File)new File(segmentDirectory, "metadata.properties"));
        metadataProperties.subset("startree.v2").clear();
        try (FileOutputStream fileOutputStream = new FileOutputStream(metadataProperties.getFile());){
            metadataProperties.save((OutputStream)fileOutputStream);
        }
        FileUtils.forceDelete((File)new File(segmentDirectory, "star_tree_index"));
        FileUtils.forceDelete((File)new File(segmentDirectory, "star_tree_index_map"));
    }
}

