/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;

public class StarTreeBuilderUtils {
    public static final int INVALID_ID = -1;

    private StarTreeBuilderUtils() {
    }

    public static List<StarTreeV2BuilderConfig> generateBuilderConfigs(@Nullable List<StarTreeIndexConfig> indexConfigs, boolean enableDefaultStarTree, SegmentMetadataImpl segmentMetadata) {
        StarTreeV2BuilderConfig defaultConfig;
        ArrayList<StarTreeV2BuilderConfig> builderConfigs = new ArrayList<StarTreeV2BuilderConfig>();
        if (indexConfigs != null) {
            for (StarTreeIndexConfig indexConfig : indexConfigs) {
                StarTreeV2BuilderConfig builderConfig = StarTreeV2BuilderConfig.fromIndexConfig(indexConfig);
                if (builderConfigs.contains(builderConfig)) continue;
                builderConfigs.add(builderConfig);
            }
        }
        if (enableDefaultStarTree && !builderConfigs.contains(defaultConfig = StarTreeV2BuilderConfig.generateDefaultConfig(segmentMetadata))) {
            builderConfigs.add(defaultConfig);
        }
        return builderConfigs;
    }

    public static void serializeTree(File starTreeFile, TreeNode rootNode, String[] dimensions, int numNodes) throws IOException {
        int headerSizeInBytes = StarTreeBuilderUtils.computeHeaderByteSize(dimensions);
        long totalSizeInBytes = (long)headerSizeInBytes + (long)numNodes * 28L;
        try (PinotDataBuffer buffer = PinotDataBuffer.mapFile(starTreeFile, false, 0L, totalSizeInBytes, ByteOrder.LITTLE_ENDIAN, "StarTreeBuilderUtils#serializeTree: star-tree buffer");){
            long offset = StarTreeBuilderUtils.writeHeader(buffer, headerSizeInBytes, dimensions, numNodes);
            StarTreeBuilderUtils.writeNodes(buffer, offset, rootNode);
        }
    }

    private static int computeHeaderByteSize(String[] dimensions) {
        int headerSizeInBytes = 20;
        for (String dimension : dimensions) {
            headerSizeInBytes += 4;
            headerSizeInBytes += 4;
            headerSizeInBytes += StringUtil.encodeUtf8((String)dimension).length;
        }
        return headerSizeInBytes += 4;
    }

    private static int writeHeader(PinotDataBuffer dataBuffer, int headerSizeInBytes, String[] dimensions, int numNodes) {
        int offset = 0;
        dataBuffer.putLong(offset, -4981643802526953459L);
        dataBuffer.putInt(offset += 8, 1);
        dataBuffer.putInt(offset += 4, headerSizeInBytes);
        int numDimensions = dimensions.length;
        dataBuffer.putInt(offset += 4, numDimensions);
        offset += 4;
        for (int i = 0; i < numDimensions; ++i) {
            dataBuffer.putInt(offset, i);
            String dimension = dimensions[i];
            byte[] dimensionBytes = StringUtil.encodeUtf8((String)dimension);
            int dimensionLength = dimensionBytes.length;
            dataBuffer.putInt(offset += 4, dimensionLength);
            dataBuffer.readFrom((long)(offset += 4), dimensionBytes, 0, dimensionLength);
            offset += dimensionLength;
        }
        dataBuffer.putInt(offset, numNodes);
        return offset += 4;
    }

    private static void writeNodes(PinotDataBuffer dataBuffer, long offset, TreeNode rootNode) {
        LinkedList<TreeNode> queue = new LinkedList<TreeNode>();
        queue.add(rootNode);
        int currentNodeId = 0;
        while (!queue.isEmpty()) {
            TreeNode node = (TreeNode)queue.remove();
            if (node._children == null) {
                offset = StarTreeBuilderUtils.writeNode(dataBuffer, offset, node, -1, -1);
            } else {
                ArrayList<TreeNode> sortedChildren = new ArrayList<TreeNode>(node._children.values());
                sortedChildren.sort((o1, o2) -> Integer.compare(o1._dimensionValue, o2._dimensionValue));
                int firstChildId = currentNodeId + queue.size() + 1;
                int lastChildId = firstChildId + sortedChildren.size() - 1;
                offset = StarTreeBuilderUtils.writeNode(dataBuffer, offset, node, firstChildId, lastChildId);
                queue.addAll(sortedChildren);
            }
            ++currentNodeId;
        }
    }

    private static long writeNode(PinotDataBuffer dataBuffer, long offset, TreeNode node, int firstChildId, int lastChildId) {
        dataBuffer.putInt(offset, node._dimensionId);
        dataBuffer.putInt(offset += 4L, node._dimensionValue);
        dataBuffer.putInt(offset += 4L, node._startDocId);
        dataBuffer.putInt(offset += 4L, node._endDocId);
        dataBuffer.putInt(offset += 4L, node._aggregatedDocId);
        dataBuffer.putInt(offset += 4L, firstChildId);
        dataBuffer.putInt(offset += 4L, lastChildId);
        return offset += 4L;
    }

    public static class TreeNode {
        public int _dimensionId = -1;
        public int _dimensionValue = -1;
        public int _startDocId = -1;
        public int _endDocId = -1;
        public int _aggregatedDocId = -1;
        public int _childDimensionId = -1;
        public Map<Integer, TreeNode> _children;
    }
}

