/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.virtualcolumn;

import org.apache.pinot.common.utils.NetUtil;
import org.apache.pinot.core.segment.index.column.DefaultNullValueVirtualColumnProvider;
import org.apache.pinot.core.segment.virtualcolumn.DocIdVirtualColumnProvider;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.plugin.PluginManager;

public class VirtualColumnProviderFactory {
    public static VirtualColumnProvider buildProvider(VirtualColumnContext virtualColumnContext) {
        String virtualColumnProvider = virtualColumnContext.getFieldSpec().getVirtualColumnProvider();
        try {
            if (virtualColumnProvider != null && !virtualColumnProvider.equals(DefaultNullValueVirtualColumnProvider.class.getName())) {
                return (VirtualColumnProvider)PluginManager.get().createInstance(virtualColumnProvider);
            }
            return new DefaultNullValueVirtualColumnProvider();
        }
        catch (Exception e) {
            throw new IllegalStateException("Caught exception while creating instance of: " + virtualColumnProvider, e);
        }
    }

    public static void addBuiltInVirtualColumnsToSegmentSchema(Schema schema, String segmentName) {
        if (!schema.hasColumn("$docId")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$docId", FieldSpec.DataType.INT, true, DocIdVirtualColumnProvider.class));
        }
        if (!schema.hasColumn("$hostName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$hostName", FieldSpec.DataType.STRING, true, DefaultNullValueVirtualColumnProvider.class, (Object)NetUtil.getHostnameOrAddress()));
        }
        if (!schema.hasColumn("$segmentName")) {
            schema.addField((FieldSpec)new DimensionFieldSpec("$segmentName", FieldSpec.DataType.STRING, true, DefaultNullValueVirtualColumnProvider.class, (Object)segmentName));
        }
    }
}

