/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.virtualcolumn;

import java.io.IOException;
import org.apache.pinot.core.segment.index.column.ColumnIndexContainer;
import org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.NullValueVectorReaderImpl;
import org.apache.pinot.core.segment.index.readers.TextIndexReader;

public class VirtualColumnIndexContainer
implements ColumnIndexContainer {
    private final ForwardIndexReader<?> _forwardIndex;
    private final InvertedIndexReader<?> _invertedIndex;
    private final Dictionary _dictionary;

    public VirtualColumnIndexContainer(ForwardIndexReader<?> forwardIndex, InvertedIndexReader<?> invertedIndex, Dictionary dictionary) {
        this._forwardIndex = forwardIndex;
        this._invertedIndex = invertedIndex;
        this._dictionary = dictionary;
    }

    @Override
    public ForwardIndexReader<?> getForwardIndex() {
        return this._forwardIndex;
    }

    @Override
    public InvertedIndexReader<?> getInvertedIndex() {
        return this._invertedIndex;
    }

    @Override
    public InvertedIndexReader<?> getRangeIndex() {
        return null;
    }

    @Override
    public TextIndexReader getTextIndex() {
        return null;
    }

    @Override
    public Dictionary getDictionary() {
        return this._dictionary;
    }

    @Override
    public BloomFilterReader getBloomFilter() {
        return null;
    }

    @Override
    public NullValueVectorReaderImpl getNullValueVector() {
        return null;
    }

    @Override
    public void close() throws IOException {
        this._forwardIndex.close();
        if (this._invertedIndex != null) {
            this._invertedIndex.close();
        }
        if (this._dictionary != null) {
            this._dictionary.close();
        }
    }
}

