/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.virtualcolumn;

import java.io.IOException;
import org.apache.pinot.common.utils.Pairs;
import org.apache.pinot.core.segment.index.column.BaseVirtualColumnProvider;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.readers.Dictionary;
import org.apache.pinot.core.segment.index.readers.DocIdDictionary;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReaderContext;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.index.readers.SortedIndexReader;
import org.apache.pinot.core.segment.virtualcolumn.VirtualColumnContext;

public class DocIdVirtualColumnProvider
extends BaseVirtualColumnProvider {
    private static final DocIdSortedIndexReader DOC_ID_SORTED_INDEX_READER = new DocIdSortedIndexReader();

    @Override
    public ForwardIndexReader<?> buildForwardIndex(VirtualColumnContext context) {
        return DOC_ID_SORTED_INDEX_READER;
    }

    @Override
    public Dictionary buildDictionary(VirtualColumnContext context) {
        return new DocIdDictionary(context.getTotalDocCount());
    }

    @Override
    public ColumnMetadata buildMetadata(VirtualColumnContext context) {
        ColumnMetadata.Builder columnMetadataBuilder = super.getColumnMetadataBuilder(context);
        columnMetadataBuilder.setCardinality(context.getTotalDocCount()).setHasDictionary(true).setHasInvertedIndex(true).setSingleValue(true).setIsSorted(true);
        return columnMetadataBuilder.build();
    }

    @Override
    public InvertedIndexReader<?> buildInvertedIndex(VirtualColumnContext context) {
        return DOC_ID_SORTED_INDEX_READER;
    }

    private static class DocIdSortedIndexReader
    implements SortedIndexReader<ForwardIndexReaderContext> {
        private DocIdSortedIndexReader() {
        }

        @Override
        public int getDictId(int docId, ForwardIndexReaderContext context) {
            return docId;
        }

        @Override
        public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, ForwardIndexReaderContext context) {
            System.arraycopy(docIds, 0, dictIdBuffer, 0, length);
        }

        @Override
        public Pairs.IntPair getDocIds(int dictId) {
            return new Pairs.IntPair(dictId, dictId);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

