/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.core.segment.store.SegmentLocalFSDirectory;

public abstract class SegmentDirectory
implements Closeable {
    public static SegmentDirectory createFromLocalFS(File directory, SegmentMetadataImpl metadata, ReadMode readMode) {
        return new SegmentLocalFSDirectory(directory, metadata, readMode);
    }

    public static SegmentDirectory createFromLocalFS(File directory, ReadMode readMode) throws IOException, ConfigurationException {
        return new SegmentLocalFSDirectory(directory, readMode);
    }

    public static SegmentMetadataImpl loadSegmentMetadata(File directory) throws IOException, ConfigurationException {
        return SegmentLocalFSDirectory.loadSegmentMetadata(directory);
    }

    public abstract void reloadMetadata() throws Exception;

    public abstract Path getPath();

    public abstract long getDiskSizeBytes();

    public abstract Reader createReader() throws IOException, ConfigurationException;

    public abstract Writer createWriter() throws IOException;

    public abstract String toString();

    protected SegmentDirectory() {
    }

    public abstract class Writer
    extends Reader {
        public abstract PinotDataBuffer newIndexFor(String var1, ColumnIndexType var2, long var3) throws IOException;

        public abstract boolean isIndexRemovalSupported();

        public abstract void removeIndex(String var1, ColumnIndexType var2);

        public void saveAndClose() throws IOException {
            this.save();
            this.close();
        }

        public void abortAndClose() throws Exception {
            this.abort();
            this.close();
        }

        public abstract void save() throws IOException;

        abstract void abort();

        public SegmentDirectory toSegmentDirectory() {
            return SegmentDirectory.this;
        }

        @Override
        public abstract String toString();
    }

    public abstract class Reader
    implements Closeable {
        public abstract PinotDataBuffer getIndexFor(String var1, ColumnIndexType var2) throws IOException;

        public abstract boolean hasIndexFor(String var1, ColumnIndexType var2);

        public abstract String toString();
    }
}

