/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.store;

public enum ColumnIndexType {
    DICTIONARY("dictionary"),
    FORWARD_INDEX("forward_index"),
    INVERTED_INDEX("inverted_index"),
    BLOOM_FILTER("bloom_filter"),
    NULLVALUE_VECTOR("nullvalue_vector"),
    TEXT_INDEX("text_index"),
    RANGE_INDEX("range_index");

    private final String indexName;

    private ColumnIndexType(String name) {
        this.indexName = name;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public static ColumnIndexType getValue(String val) {
        for (ColumnIndexType type : ColumnIndexType.values()) {
            if (!type.getIndexName().equalsIgnoreCase(val)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown value: " + val);
    }
}

