/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.store;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.pinot.common.segment.ReadMode;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.segment.store.ColumnIndexType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ColumnIndexDirectory
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnIndexDirectory.class);
    protected File segmentDirectory;
    protected SegmentMetadataImpl metadata;
    protected ReadMode readMode;

    protected ColumnIndexDirectory(File segmentDirectory, SegmentMetadataImpl metadata, ReadMode readMode) {
        Preconditions.checkNotNull((Object)segmentDirectory);
        Preconditions.checkNotNull((Object)readMode);
        Preconditions.checkNotNull((Object)metadata);
        Preconditions.checkArgument((boolean)segmentDirectory.exists(), (Object)("SegmentDirectory: " + segmentDirectory.toString() + " does not exist"));
        Preconditions.checkArgument((boolean)segmentDirectory.isDirectory(), (Object)("SegmentDirectory: " + segmentDirectory.toString() + " is not a directory"));
        this.segmentDirectory = segmentDirectory;
        this.metadata = metadata;
        this.readMode = readMode;
    }

    protected String allocationContext(File f, String context) {
        return this.getClass().getSimpleName() + "." + f.toString() + "." + context;
    }

    public abstract PinotDataBuffer getBuffer(String var1, ColumnIndexType var2) throws IOException;

    public abstract PinotDataBuffer newBuffer(String var1, ColumnIndexType var2, long var3) throws IOException;

    public abstract boolean hasIndexFor(String var1, ColumnIndexType var2);

    public abstract void removeIndex(String var1, ColumnIndexType var2);

    public abstract boolean isIndexRemovalSupported();
}

