/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.utils;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.readers.GenericRow;

public final class SegmentProcessorUtils {
    private SegmentProcessorUtils() {
    }

    public static GenericData.Record convertGenericRowToAvroRecord(GenericRow genericRow, GenericData.Record reusableRecord) {
        for (String field : genericRow.getFieldToValueMap().keySet()) {
            Object value = genericRow.getValue(field);
            if (value instanceof Object[]) {
                reusableRecord.put(field, Arrays.asList((Object[])value));
                continue;
            }
            if (value instanceof byte[]) {
                value = ByteBuffer.wrap((byte[])value);
            }
            reusableRecord.put(field, value);
        }
        return reusableRecord;
    }

    public static Schema convertPinotSchemaToAvroSchema(org.apache.pinot.spi.data.Schema pinotSchema) {
        SchemaBuilder.FieldAssembler fieldAssembler = SchemaBuilder.record((String)"record").fields();
        block15: for (FieldSpec fieldSpec : pinotSchema.getAllFieldSpecs()) {
            String name = fieldSpec.getName();
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            if (fieldSpec.isSingleValueField()) {
                switch (dataType) {
                    case INT: {
                        fieldAssembler = fieldAssembler.name(name).type().intType().noDefault();
                        continue block15;
                    }
                    case LONG: {
                        fieldAssembler = fieldAssembler.name(name).type().longType().noDefault();
                        continue block15;
                    }
                    case FLOAT: {
                        fieldAssembler = fieldAssembler.name(name).type().floatType().noDefault();
                        continue block15;
                    }
                    case DOUBLE: {
                        fieldAssembler = fieldAssembler.name(name).type().doubleType().noDefault();
                        continue block15;
                    }
                    case STRING: {
                        fieldAssembler = fieldAssembler.name(name).type().stringType().noDefault();
                        continue block15;
                    }
                    case BYTES: {
                        fieldAssembler = fieldAssembler.name(name).type().bytesType().noDefault();
                        continue block15;
                    }
                }
                throw new RuntimeException("Unsupported data type: " + dataType);
            }
            switch (dataType) {
                case INT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().intType()).noDefault();
                    continue block15;
                }
                case LONG: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().longType()).noDefault();
                    continue block15;
                }
                case FLOAT: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().floatType()).noDefault();
                    continue block15;
                }
                case DOUBLE: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().doubleType()).noDefault();
                    continue block15;
                }
                case STRING: {
                    fieldAssembler = ((SchemaBuilder.ArrayDefault)fieldAssembler.name(name).type().array().items().stringType()).noDefault();
                    continue block15;
                }
            }
            throw new RuntimeException("Unsupported data type: " + dataType);
        }
        return (Schema)fieldAssembler.endRecord();
    }
}

