/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.partitioner;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.segment.processing.partitioner.ColumnValuePartitioner;
import org.apache.pinot.core.segment.processing.partitioner.NoOpPartitioner;
import org.apache.pinot.core.segment.processing.partitioner.Partitioner;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.partitioner.RoundRobinPartitioner;
import org.apache.pinot.core.segment.processing.partitioner.TableConfigPartitioner;
import org.apache.pinot.core.segment.processing.partitioner.TransformFunctionPartitioner;

public final class PartitionerFactory {
    private PartitionerFactory() {
    }

    public static Partitioner getPartitioner(PartitionerConfig config) {
        Partitioner partitioner = null;
        switch (config.getPartitionerType()) {
            case NO_OP: {
                partitioner = new NoOpPartitioner();
                break;
            }
            case ROUND_ROBIN: {
                Preconditions.checkState((config.getNumPartitions() > 0 ? 1 : 0) != 0, (Object)"Must provide numPartitions > 0 for ROUND_ROBIN partitioner");
                partitioner = new RoundRobinPartitioner(config.getNumPartitions());
                break;
            }
            case COLUMN_VALUE: {
                Preconditions.checkState((config.getColumnName() != null ? 1 : 0) != 0, (Object)"Must provide columnName for COLUMN_VALUE partitioner");
                partitioner = new ColumnValuePartitioner(config.getColumnName());
                break;
            }
            case TRANSFORM_FUNCTION: {
                Preconditions.checkState((config.getTransformFunction() != null ? 1 : 0) != 0, (Object)"Must provide transformFunction for TRANSFORM_FUNCTION partitioner");
                partitioner = new TransformFunctionPartitioner(config.getTransformFunction());
                break;
            }
            case TABLE_PARTITION_CONFIG: {
                Preconditions.checkState((config.getColumnName() != null ? 1 : 0) != 0, (Object)"Must provide columnName for TABLE_PARTITION_CONFIG Partitioner");
                Preconditions.checkState((config.getColumnPartitionConfig() != null ? 1 : 0) != 0, (Object)"Must provide columnPartitionConfig for TABLE_PARTITION_CONFIG Partitioner");
                partitioner = new TableConfigPartitioner(config.getColumnName(), config.getColumnPartitionConfig());
            }
        }
        return partitioner;
    }

    public static enum PartitionerType {
        NO_OP,
        ROUND_ROBIN,
        COLUMN_VALUE,
        TRANSFORM_FUNCTION,
        TABLE_PARTITION_CONFIG;

    }
}

