/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.pinot.core.segment.processing.collector.Collector;
import org.apache.pinot.core.segment.processing.collector.CollectorFactory;
import org.apache.pinot.core.segment.processing.framework.SegmentReducerConfig;
import org.apache.pinot.core.segment.processing.utils.SegmentProcessorUtils;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentReducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentReducer.class);
    private final File _reducerInputDir;
    private final File _reducerOutputDir;
    private final String _reducerId;
    private final org.apache.pinot.spi.data.Schema _pinotSchema;
    private final Schema _avroSchema;
    private final Collector _collector;
    private final int _numRecordsPerPart;

    public SegmentReducer(String reducerId, File reducerInputDir, SegmentReducerConfig reducerConfig, File reducerOutputDir) {
        this._reducerInputDir = reducerInputDir;
        this._reducerOutputDir = reducerOutputDir;
        this._reducerId = reducerId;
        this._pinotSchema = reducerConfig.getPinotSchema();
        this._avroSchema = SegmentProcessorUtils.convertPinotSchemaToAvroSchema(this._pinotSchema);
        this._collector = CollectorFactory.getCollector(reducerConfig.getCollectorConfig(), this._pinotSchema);
        this._numRecordsPerPart = reducerConfig.getNumRecordsPerPart();
        LOGGER.info("Initialized reducer with id: {}, input dir: {}, output dir: {}, collector: {}, numRecordsPerPart: {}", new Object[]{this._reducerId, this._reducerInputDir, this._reducerOutputDir, this._collector.getClass(), this._numRecordsPerPart});
    }

    public void reduce() throws Exception {
        int part = 0;
        for (File inputFile : this._reducerInputDir.listFiles()) {
            RecordReader avroRecordReader = RecordReaderFactory.getRecordReaderByClass((String)"org.apache.pinot.plugin.inputformat.avro.AvroRecordReader", (File)inputFile, (Set)this._pinotSchema.getColumnNames(), null);
            while (avroRecordReader.hasNext()) {
                GenericRow next = avroRecordReader.next();
                this._collector.collect(next);
                if (this._collector.size() != this._numRecordsPerPart) continue;
                this.flushRecords(this._collector, SegmentReducer.createReducerOutputFileName(this._reducerId, part++));
                this._collector.reset();
            }
        }
        if (this._collector.size() > 0) {
            this.flushRecords(this._collector, SegmentReducer.createReducerOutputFileName(this._reducerId, part));
            this._collector.reset();
        }
    }

    private void flushRecords(Collector collector, String fileName) throws IOException {
        GenericData.Record reusableRecord = new GenericData.Record(this._avroSchema);
        Iterator<GenericRow> collectionIt = collector.iterator();
        DataFileWriter recordWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this._avroSchema));
        recordWriter.create(this._avroSchema, new File(this._reducerOutputDir, fileName));
        while (collectionIt.hasNext()) {
            SegmentProcessorUtils.convertGenericRowToAvroRecord(collectionIt.next(), reusableRecord);
            recordWriter.append((Object)reusableRecord);
        }
        recordWriter.close();
    }

    public static String createReducerOutputFileName(String reducerId, int part) {
        return "reducer_" + reducerId + "_" + part + ".avro";
    }

    public void cleanup() {
    }
}

