/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.core.segment.processing.collector.CollectorConfig;
import org.apache.pinot.core.segment.processing.filter.RecordFilterConfig;
import org.apache.pinot.core.segment.processing.framework.SegmentConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class SegmentProcessorConfig {
    private final TableConfig _tableConfig;
    private final Schema _schema;
    private final RecordTransformerConfig _recordTransformerConfig;
    private final RecordFilterConfig _recordFilterConfig;
    private final List<PartitionerConfig> _partitionerConfigs;
    private final CollectorConfig _collectorConfig;
    private final SegmentConfig _segmentConfig;

    private SegmentProcessorConfig(TableConfig tableConfig, Schema schema, RecordTransformerConfig recordTransformerConfig, RecordFilterConfig recordFilterConfig, List<PartitionerConfig> partitionerConfigs, CollectorConfig collectorConfig, SegmentConfig segmentConfig) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._recordTransformerConfig = recordTransformerConfig;
        this._recordFilterConfig = recordFilterConfig;
        this._partitionerConfigs = partitionerConfigs;
        this._collectorConfig = collectorConfig;
        this._segmentConfig = segmentConfig;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public RecordTransformerConfig getRecordTransformerConfig() {
        return this._recordTransformerConfig;
    }

    public RecordFilterConfig getRecordFilterConfig() {
        return this._recordFilterConfig;
    }

    public List<PartitionerConfig> getPartitionerConfigs() {
        return this._partitionerConfigs;
    }

    public CollectorConfig getCollectorConfig() {
        return this._collectorConfig;
    }

    public SegmentConfig getSegmentConfig() {
        return this._segmentConfig;
    }

    public String toString() {
        return "SegmentProcessorConfig{\n_tableConfig=" + this._tableConfig + ", \n_schema=" + this._schema.toSingleLineJsonString() + ", \n_recordFilterConfig=" + this._recordFilterConfig + ", \n_recordTransformerConfig=" + this._recordTransformerConfig + ", \n_partitionerConfigs=" + this._partitionerConfigs + ", \n_collectorConfig=" + this._collectorConfig + ", \n_segmentsConfig=" + this._segmentConfig + "\n}";
    }

    public static class Builder {
        private TableConfig _tableConfig;
        private Schema _schema;
        private RecordTransformerConfig _recordTransformerConfig;
        private RecordFilterConfig _recordFilterConfig;
        private List<PartitionerConfig> _partitionerConfigs;
        private CollectorConfig _collectorConfig;
        private SegmentConfig _segmentConfig;

        public Builder setTableConfig(TableConfig tableConfig) {
            this._tableConfig = tableConfig;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setRecordTransformerConfig(RecordTransformerConfig recordTransformerConfig) {
            this._recordTransformerConfig = recordTransformerConfig;
            return this;
        }

        public Builder setRecordFilterConfig(RecordFilterConfig recordFilterConfig) {
            this._recordFilterConfig = recordFilterConfig;
            return this;
        }

        public Builder setPartitionerConfigs(List<PartitionerConfig> partitionerConfigs) {
            this._partitionerConfigs = partitionerConfigs;
            return this;
        }

        public Builder setCollectorConfig(CollectorConfig collectorConfig) {
            this._collectorConfig = collectorConfig;
            return this;
        }

        public Builder setSegmentConfig(SegmentConfig segmentConfig) {
            this._segmentConfig = segmentConfig;
            return this;
        }

        public SegmentProcessorConfig build() {
            Preconditions.checkState((this._tableConfig != null ? 1 : 0) != 0, (Object)"Must provide table config in SegmentProcessorConfig");
            Preconditions.checkState((this._schema != null ? 1 : 0) != 0, (Object)"Must provide schema in SegmentProcessorConfig");
            if (this._recordTransformerConfig == null) {
                this._recordTransformerConfig = new RecordTransformerConfig.Builder().build();
            }
            if (this._recordFilterConfig == null) {
                this._recordFilterConfig = new RecordFilterConfig.Builder().build();
            }
            if (CollectionUtils.isEmpty(this._partitionerConfigs)) {
                this._partitionerConfigs = Lists.newArrayList((Object[])new PartitionerConfig[]{new PartitionerConfig.Builder().build()});
            }
            if (this._collectorConfig == null) {
                this._collectorConfig = new CollectorConfig.Builder().build();
            }
            if (this._segmentConfig == null) {
                this._segmentConfig = new SegmentConfig.Builder().build();
            }
            return new SegmentProcessorConfig(this._tableConfig, this._schema, this._recordTransformerConfig, this._recordFilterConfig, this._partitionerConfigs, this._collectorConfig, this._segmentConfig);
        }
    }
}

