/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.core.data.readers.PinotSegmentRecordReader;
import org.apache.pinot.core.segment.processing.filter.RecordFilter;
import org.apache.pinot.core.segment.processing.filter.RecordFilterFactory;
import org.apache.pinot.core.segment.processing.framework.SegmentMapperConfig;
import org.apache.pinot.core.segment.processing.partitioner.Partitioner;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerFactory;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformer;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformerFactory;
import org.apache.pinot.core.segment.processing.utils.SegmentProcessorUtils;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMapper.class);
    private final File _inputSegment;
    private final File _mapperOutputDir;
    private final String _mapperId;
    private final Schema _avroSchema;
    private final RecordTransformer _recordTransformer;
    private final RecordFilter _recordFilter;
    private final int _numPartitioners;
    private final List<Partitioner> _partitioners = new ArrayList<Partitioner>();
    private final Map<String, DataFileWriter<GenericData.Record>> _partitionToDataFileWriterMap = new HashMap<String, DataFileWriter<GenericData.Record>>();

    public SegmentMapper(String mapperId, File inputSegment, SegmentMapperConfig mapperConfig, File mapperOutputDir) {
        this._inputSegment = inputSegment;
        this._mapperOutputDir = mapperOutputDir;
        this._mapperId = mapperId;
        this._avroSchema = SegmentProcessorUtils.convertPinotSchemaToAvroSchema(mapperConfig.getPinotSchema());
        this._recordFilter = RecordFilterFactory.getRecordFilter(mapperConfig.getRecordFilterConfig());
        this._recordTransformer = RecordTransformerFactory.getRecordTransformer(mapperConfig.getRecordTransformerConfig());
        for (PartitionerConfig partitionerConfig : mapperConfig.getPartitionerConfigs()) {
            this._partitioners.add(PartitionerFactory.getPartitioner(partitionerConfig));
        }
        this._numPartitioners = this._partitioners.size();
        LOGGER.info("Initialized mapper with id: {}, input segment: {}, output dir: {}, recordTransformer: {}, recordFilter: {}, partitioners: {}", new Object[]{this._mapperId, this._inputSegment, this._mapperOutputDir, this._recordTransformer.getClass(), this._recordFilter.getClass(), this._partitioners.stream().map(p -> p.getClass().toString()).collect(Collectors.joining(","))});
    }

    public void map() throws Exception {
        PinotSegmentRecordReader segmentRecordReader = new PinotSegmentRecordReader(this._inputSegment);
        GenericRow reusableRow = new GenericRow();
        GenericData.Record reusableRecord = new GenericData.Record(this._avroSchema);
        String[] partitions = new String[this._numPartitioners];
        while (segmentRecordReader.hasNext()) {
            if (this._recordFilter.filter(reusableRow = segmentRecordReader.next(reusableRow))) continue;
            reusableRow = this._recordTransformer.transformRecord(reusableRow);
            int p = 0;
            for (Partitioner partitioner : this._partitioners) {
                partitions[p++] = partitioner.getPartition(reusableRow);
            }
            String partition = StringUtil.join((String)"_", (String[])partitions);
            DataFileWriter recordWriter = this._partitionToDataFileWriterMap.get(partition);
            if (recordWriter == null) {
                File partDir = new File(this._mapperOutputDir, partition);
                if (!partDir.exists()) {
                    Files.createDirectory(Paths.get(partDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
                }
                recordWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(this._avroSchema));
                recordWriter.create(this._avroSchema, new File(partDir, SegmentMapper.createMapperOutputFileName(this._mapperId)));
                this._partitionToDataFileWriterMap.put(partition, (DataFileWriter<GenericData.Record>)recordWriter);
            }
            SegmentProcessorUtils.convertGenericRowToAvroRecord(reusableRow, reusableRecord);
            recordWriter.append((Object)reusableRecord);
        }
    }

    public void cleanup() throws IOException {
        for (DataFileWriter<GenericData.Record> recordDataFileWriter : this._partitionToDataFileWriterMap.values()) {
            recordDataFileWriter.close();
        }
    }

    public static String createMapperOutputFileName(String mapperId) {
        return "mapper_" + mapperId + ".avro";
    }
}

