/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.framework;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SegmentConfig {
    private static final int DEFAULT_MAX_NUM_RECORDS_PER_SEGMENT = 5000000;
    private final int _maxNumRecordsPerSegment;

    @JsonCreator
    private SegmentConfig(@JsonProperty(value="maxNumRecordsPerSegment") int maxNumRecordsPerSegment) {
        Preconditions.checkState((maxNumRecordsPerSegment > 0 ? 1 : 0) != 0, (Object)"Max num records per segment must be > 0");
        this._maxNumRecordsPerSegment = maxNumRecordsPerSegment;
    }

    @JsonProperty
    public int getMaxNumRecordsPerSegment() {
        return this._maxNumRecordsPerSegment;
    }

    public String toString() {
        return "SegmentsConfig{_maxNumRecordsPerSegment=" + this._maxNumRecordsPerSegment + '}';
    }

    public static class Builder {
        private int _maxNumRecordsPerSegment = 5000000;

        public Builder setMaxNumRecordsPerSegment(int maxNumRecordsPerSegment) {
            this._maxNumRecordsPerSegment = maxNumRecordsPerSegment;
            return this;
        }

        public SegmentConfig build() {
            Preconditions.checkState((this._maxNumRecordsPerSegment > 0 ? 1 : 0) != 0, (Object)"Max num records per segment must be > 0");
            return new SegmentConfig(this._maxNumRecordsPerSegment);
        }
    }
}

