/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.collector;

import org.apache.pinot.core.segment.processing.collector.MaxValueAggregator;
import org.apache.pinot.core.segment.processing.collector.MinValueAggregator;
import org.apache.pinot.core.segment.processing.collector.SumValueAggregator;
import org.apache.pinot.core.segment.processing.collector.ValueAggregator;
import org.apache.pinot.spi.data.FieldSpec;

public class ValueAggregatorFactory {
    private ValueAggregatorFactory() {
    }

    public static ValueAggregator getValueAggregator(String aggregatorTypeStr, FieldSpec.DataType dataType) {
        ValueAggregatorType aggregatorType = ValueAggregatorType.valueOf(aggregatorTypeStr.toUpperCase());
        switch (aggregatorType) {
            case SUM: {
                return new SumValueAggregator(dataType);
            }
            case MAX: {
                return new MaxValueAggregator(dataType);
            }
            case MIN: {
                return new MinValueAggregator(dataType);
            }
        }
        throw new IllegalStateException("Unsupported value aggregator type : " + aggregatorTypeStr);
    }

    public static enum ValueAggregatorType {
        SUM,
        MAX,
        MIN;

    }
}

