/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.core.segment.processing.collector.Collector;
import org.apache.pinot.core.segment.processing.collector.CollectorConfig;
import org.apache.pinot.core.segment.processing.collector.GenericRowSorter;
import org.apache.pinot.core.segment.processing.collector.ValueAggregator;
import org.apache.pinot.core.segment.processing.collector.ValueAggregatorFactory;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class RollupCollector
implements Collector {
    private final Map<Record, GenericRow> _collection = new HashMap<Record, GenericRow>();
    private final GenericRowSorter _sorter;
    private final int _keySize;
    private final int _valueSize;
    private final String[] _keyColumns;
    private final String[] _valueColumns;
    private final ValueAggregator[] _valueAggregators;

    public RollupCollector(CollectorConfig collectorConfig, Schema schema) {
        int keySize = 0;
        int valueSize = 0;
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
                ++valueSize;
                continue;
            }
            ++keySize;
        }
        this._keySize = keySize;
        this._valueSize = valueSize;
        this._keyColumns = new String[this._keySize];
        this._valueColumns = new String[this._valueSize];
        this._valueAggregators = new ValueAggregator[this._valueSize];
        Map<String, ValueAggregatorFactory.ValueAggregatorType> aggregatorTypeMap = collectorConfig.getAggregatorTypeMap();
        if (aggregatorTypeMap == null) {
            aggregatorTypeMap = Collections.emptyMap();
        }
        int valIdx = 0;
        int keyIdx = 0;
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            String name = fieldSpec.getName();
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
                this._valueColumns[valIdx] = name;
                ValueAggregatorFactory.ValueAggregatorType aggregatorType = aggregatorTypeMap.getOrDefault(name, ValueAggregatorFactory.ValueAggregatorType.SUM);
                this._valueAggregators[valIdx] = ValueAggregatorFactory.getValueAggregator(aggregatorType.toString(), fieldSpec.getDataType());
                ++valIdx;
                continue;
            }
            this._keyColumns[keyIdx++] = name;
        }
        List<String> sortOrder = collectorConfig.getSortOrder();
        this._sorter = CollectionUtils.isNotEmpty(sortOrder) ? new GenericRowSorter(sortOrder, schema) : null;
    }

    @Override
    public void collect(GenericRow genericRow) {
        Object[] key = new Object[this._keySize];
        for (int i = 0; i < this._keySize; ++i) {
            key[i] = genericRow.getValue(this._keyColumns[i]);
        }
        Record keyRecord = new Record(key);
        GenericRow prev = this._collection.get(keyRecord);
        if (prev == null) {
            this._collection.put(keyRecord, genericRow);
        } else {
            for (int i = 0; i < this._valueSize; ++i) {
                String valueColumn = this._valueColumns[i];
                Object aggregate = this._valueAggregators[i].aggregate(prev.getValue(valueColumn), genericRow.getValue(valueColumn));
                prev.putValue(valueColumn, aggregate);
            }
        }
    }

    @Override
    public Iterator<GenericRow> iterator() {
        Iterator<Object> iterator;
        if (this._sorter != null) {
            ArrayList<GenericRow> sortedRows = new ArrayList<GenericRow>(this._collection.values());
            this._sorter.sort(sortedRows);
            iterator = sortedRows.iterator();
        } else {
            iterator = this._collection.values().iterator();
        }
        return iterator;
    }

    @Override
    public int size() {
        return this._collection.size();
    }

    @Override
    public void reset() {
        this._collection.clear();
    }

    private static class Record {
        private final Object[] _keyParts;

        public Record(Object[] keyParts) {
            this._keyParts = keyParts;
        }

        public boolean equals(Object o) {
            return Arrays.deepEquals(this._keyParts, ((Record)o)._keyParts);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this._keyParts);
        }
    }
}

