/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.collector;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import java.util.List;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.ByteArray;

public class GenericRowSorter {
    private final Comparator<GenericRow> _genericRowComparator;

    public GenericRowSorter(List<String> sortOrder, Schema schema) {
        int sortOrderSize = sortOrder.size();
        FieldSpec.DataType[] dataTypes = new FieldSpec.DataType[sortOrderSize];
        for (int i = 0; i < sortOrderSize; ++i) {
            String column = sortOrder.get(i);
            FieldSpec fieldSpec = schema.getFieldSpecFor(column);
            Preconditions.checkState((fieldSpec != null ? 1 : 0) != 0, (String)"Column in sort order: %s does not exist in schema", (Object)column);
            Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (String)"Cannot use multi value column: %s for sorting", (Object)column);
            dataTypes[i] = fieldSpec.getDataType();
        }
        this._genericRowComparator = (o1, o2) -> {
            for (int i = 0; i < sortOrderSize; ++i) {
                int result;
                String column = (String)sortOrder.get(i);
                FieldSpec.DataType dataType = dataTypes[i];
                Object value1 = o1.getValue(column);
                Object value2 = o2.getValue(column);
                switch (dataType) {
                    case INT: {
                        result = Integer.compare((Integer)value1, (Integer)value2);
                        break;
                    }
                    case LONG: {
                        result = Long.compare((Long)value1, (Long)value2);
                        break;
                    }
                    case FLOAT: {
                        result = Float.compare(((Float)value1).floatValue(), ((Float)value2).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        result = Double.compare((Double)value1, (Double)value2);
                        break;
                    }
                    case STRING: {
                        result = ((String)value1).compareTo((String)value2);
                        break;
                    }
                    case BYTES: {
                        result = ByteArray.compare((byte[])((byte[])value1), (byte[])((byte[])value2));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Cannot sort on column with dataType " + dataType);
                    }
                }
                if (result == 0) continue;
                return result;
            }
            return 0;
        };
    }

    public void sort(List<GenericRow> rows) {
        rows.sort(this._genericRowComparator);
    }
}

