/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.collector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.core.segment.processing.collector.Collector;
import org.apache.pinot.core.segment.processing.collector.CollectorConfig;
import org.apache.pinot.core.segment.processing.collector.GenericRowSorter;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class ConcatCollector
implements Collector {
    private final List<GenericRow> _collection = new ArrayList<GenericRow>();
    private final GenericRowSorter _sorter;

    public ConcatCollector(CollectorConfig collectorConfig, Schema schema) {
        List<String> sortOrder = collectorConfig.getSortOrder();
        this._sorter = CollectionUtils.isNotEmpty(sortOrder) ? new GenericRowSorter(sortOrder, schema) : null;
    }

    @Override
    public void collect(GenericRow genericRow) {
        this._collection.add(genericRow);
    }

    @Override
    public Iterator<GenericRow> iterator() {
        if (this._sorter != null) {
            this._sorter.sort(this._collection);
        }
        return this._collection.iterator();
    }

    @Override
    public int size() {
        return this._collection.size();
    }

    @Override
    public void reset() {
        this._collection.clear();
    }
}

