/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.collector;

import org.apache.pinot.core.segment.processing.collector.Collector;
import org.apache.pinot.core.segment.processing.collector.CollectorConfig;
import org.apache.pinot.core.segment.processing.collector.ConcatCollector;
import org.apache.pinot.core.segment.processing.collector.RollupCollector;
import org.apache.pinot.spi.data.Schema;

public final class CollectorFactory {
    private CollectorFactory() {
    }

    public static Collector getCollector(CollectorConfig collectorConfig, Schema pinotSchema) {
        Collector collector = null;
        switch (collectorConfig.getCollectorType()) {
            case ROLLUP: {
                collector = new RollupCollector(collectorConfig, pinotSchema);
                break;
            }
            case CONCAT: {
                collector = new ConcatCollector(collectorConfig, pinotSchema);
            }
        }
        return collector;
    }

    public static enum CollectorType {
        ROLLUP,
        CONCAT;

    }
}

