/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.name;

import javax.annotation.Nullable;
import org.apache.pinot.core.segment.name.SegmentNameGenerator;

public class SimpleSegmentNameGenerator
implements SegmentNameGenerator {
    private final String _tableName;
    private final String _segmentNamePostfix;

    public SimpleSegmentNameGenerator(String tableName, String segmentNamePostfix) {
        this._tableName = tableName;
        this._segmentNamePostfix = segmentNamePostfix;
    }

    @Override
    public String generateSegmentName(int sequenceId, @Nullable Object minTimeValue, @Nullable Object maxTimeValue) {
        return JOINER.join((Object)this._tableName, minTimeValue, new Object[]{maxTimeValue, this._segmentNamePostfix, sequenceId >= 0 ? Integer.valueOf(sequenceId) : null});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("SimpleSegmentNameGenerator: tableName=").append(this._tableName);
        if (this._segmentNamePostfix != null) {
            stringBuilder.append(", segmentNamePostfix=").append(this._segmentNamePostfix);
        }
        return stringBuilder.toString();
    }
}

