/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.memory;

import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.core.segment.memory.BasePinotLBuffer;
import xerial.larray.buffer.LBuffer;
import xerial.larray.buffer.LBufferAPI;
import xerial.larray.mmap.MMapBuffer;
import xerial.larray.mmap.MMapMode;

@ThreadSafe
public class PinotNativeOrderLBuffer
extends BasePinotLBuffer {
    static PinotNativeOrderLBuffer allocateDirect(long size) {
        LBuffer buffer = new LBuffer(size);
        return new PinotNativeOrderLBuffer((LBufferAPI)buffer, true, false);
    }

    static PinotNativeOrderLBuffer loadFile(File file, long offset, long size) throws IOException {
        PinotNativeOrderLBuffer buffer = PinotNativeOrderLBuffer.allocateDirect(size);
        buffer.readFrom(0L, file, offset, size);
        return buffer;
    }

    public static PinotNativeOrderLBuffer mapFile(File file, boolean readOnly, long offset, long size) throws IOException {
        if (readOnly) {
            return new PinotNativeOrderLBuffer((LBufferAPI)new MMapBuffer(file, offset, size, MMapMode.READ_ONLY), true, false);
        }
        return new PinotNativeOrderLBuffer((LBufferAPI)new MMapBuffer(file, offset, size, MMapMode.READ_WRITE), true, true);
    }

    PinotNativeOrderLBuffer(LBufferAPI buffer, boolean closeable, boolean flushable) {
        super(buffer, closeable, flushable);
    }

    @Override
    public char getChar(int offset) {
        return this._buffer.getChar(offset);
    }

    @Override
    public char getChar(long offset) {
        return this._buffer.getChar(offset);
    }

    @Override
    public void putChar(int offset, char value) {
        this._buffer.putChar(offset, value);
    }

    @Override
    public void putChar(long offset, char value) {
        this._buffer.putChar(offset, value);
    }

    @Override
    public short getShort(int offset) {
        return this._buffer.getShort(offset);
    }

    @Override
    public short getShort(long offset) {
        return this._buffer.getShort(offset);
    }

    @Override
    public void putShort(int offset, short value) {
        this._buffer.putShort(offset, value);
    }

    @Override
    public void putShort(long offset, short value) {
        this._buffer.putShort(offset, value);
    }

    @Override
    public int getInt(int offset) {
        return this._buffer.getInt(offset);
    }

    @Override
    public int getInt(long offset) {
        return this._buffer.getInt(offset);
    }

    @Override
    public void putInt(int offset, int value) {
        this._buffer.putInt(offset, value);
    }

    @Override
    public void putInt(long offset, int value) {
        this._buffer.putInt(offset, value);
    }

    @Override
    public long getLong(int offset) {
        return this._buffer.getLong(offset);
    }

    @Override
    public long getLong(long offset) {
        return this._buffer.getLong(offset);
    }

    @Override
    public void putLong(int offset, long value) {
        this._buffer.putLong(offset, value);
    }

    @Override
    public void putLong(long offset, long value) {
        this._buffer.putLong(offset, value);
    }

    @Override
    public float getFloat(int offset) {
        return this._buffer.getFloat(offset);
    }

    @Override
    public float getFloat(long offset) {
        return this._buffer.getFloat(offset);
    }

    @Override
    public void putFloat(int offset, float value) {
        this._buffer.putFloat(offset, value);
    }

    @Override
    public void putFloat(long offset, float value) {
        this._buffer.putFloat(offset, value);
    }

    @Override
    public double getDouble(int offset) {
        return this._buffer.getDouble(offset);
    }

    @Override
    public double getDouble(long offset) {
        return this._buffer.getDouble(offset);
    }

    @Override
    public void putDouble(int offset, double value) {
        this._buffer.putDouble(offset, value);
    }

    @Override
    public void putDouble(long offset, double value) {
        this._buffer.putDouble(offset, value);
    }

    @Override
    public ByteOrder order() {
        return NATIVE_ORDER;
    }
}

