/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.memory;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.segment.memory.PinotNativeOrderLBuffer;
import org.apache.pinot.core.segment.memory.PinotNonNativeOrderLBuffer;
import xerial.larray.buffer.LBuffer;
import xerial.larray.buffer.LBufferAPI;
import xerial.larray.buffer.WrappedLBuffer;
import xerial.larray.mmap.MMapBuffer;

@ThreadSafe
public abstract class BasePinotLBuffer
extends PinotDataBuffer {
    protected final LBufferAPI _buffer;
    private final boolean _flushable;

    protected BasePinotLBuffer(LBufferAPI buffer, boolean closeable, boolean flushable) {
        super(closeable);
        this._buffer = buffer;
        this._flushable = flushable;
    }

    @Override
    public byte getByte(int offset) {
        return this._buffer.getByte(offset);
    }

    @Override
    public byte getByte(long offset) {
        return this._buffer.getByte(offset);
    }

    @Override
    public void putByte(int offset, byte value) {
        this._buffer.putByte(offset, value);
    }

    @Override
    public void putByte(long offset, byte value) {
        this._buffer.putByte(offset, value);
    }

    @Override
    public void copyTo(long offset, byte[] buffer, int destOffset, int size) {
        if (size <= PinotDataBuffer.BULK_BYTES_PROCESSING_THRESHOLD) {
            int end = destOffset + size;
            for (int i = destOffset; i < end; ++i) {
                buffer[i] = this._buffer.getByte(offset++);
            }
        } else {
            this._buffer.toDirectByteBuffer(offset, size).get(buffer, destOffset, size);
        }
    }

    @Override
    public void copyTo(long offset, PinotDataBuffer buffer, long destOffset, long size) {
        if (buffer instanceof BasePinotLBuffer) {
            this._buffer.copyTo(offset, ((BasePinotLBuffer)buffer)._buffer, destOffset, size);
        } else {
            assert (size <= Integer.MAX_VALUE);
            buffer.readFrom(destOffset, this._buffer.toDirectByteBuffer(offset, (int)size));
        }
    }

    @Override
    public void readFrom(long offset, byte[] buffer, int srcOffset, int size) {
        if (size <= PinotDataBuffer.BULK_BYTES_PROCESSING_THRESHOLD) {
            int end = srcOffset + size;
            for (int i = srcOffset; i < end; ++i) {
                this._buffer.putByte(offset++, buffer[i]);
            }
        } else {
            this._buffer.toDirectByteBuffer(offset, size).put(buffer, srcOffset, size);
        }
    }

    @Override
    public void readFrom(long offset, ByteBuffer buffer) {
        this._buffer.toDirectByteBuffer(offset, buffer.remaining()).put(buffer);
    }

    @Override
    public void readFrom(long offset, File file, long srcOffset, long size) throws IOException {
        try (FileChannel fileChannel = new RandomAccessFile(file, "r").getChannel();){
            if (size <= Integer.MAX_VALUE) {
                fileChannel.read(this._buffer.toDirectByteBuffer(offset, (int)size), srcOffset);
            } else {
                while (size > Integer.MAX_VALUE) {
                    fileChannel.read(this._buffer.toDirectByteBuffer(offset, Integer.MAX_VALUE), srcOffset);
                    offset += Integer.MAX_VALUE;
                    srcOffset += Integer.MAX_VALUE;
                    size -= Integer.MAX_VALUE;
                }
                fileChannel.read(this._buffer.toDirectByteBuffer(offset, (int)size), srcOffset);
            }
        }
    }

    @Override
    public long size() {
        if (this._buffer instanceof MMapBuffer) {
            return this._buffer.m.address() + this._buffer.m.size() - this._buffer.address();
        }
        return this._buffer.size();
    }

    @Override
    public PinotDataBuffer view(long start, long end, ByteOrder byteOrder) {
        if (byteOrder == NATIVE_ORDER) {
            return new PinotNativeOrderLBuffer((LBufferAPI)new WrappedLBuffer(this._buffer.m, start + this._buffer.address() - this._buffer.m.address(), end - start), false, false);
        }
        return new PinotNonNativeOrderLBuffer((LBufferAPI)new WrappedLBuffer(this._buffer.m, start + this._buffer.address() - this._buffer.m.address(), end - start), false, false);
    }

    @Override
    public ByteBuffer toDirectByteBuffer(long offset, int size, ByteOrder byteOrder) {
        return this._buffer.toDirectByteBuffer(offset, size).order(byteOrder);
    }

    @Override
    public void flush() {
        if (this._flushable) {
            ((MMapBuffer)this._buffer).flush();
        }
    }

    @Override
    protected void release() throws IOException {
        if (this._buffer instanceof LBuffer) {
            this._buffer.release();
        } else if (this._buffer instanceof MMapBuffer) {
            ((MMapBuffer)this._buffer).close();
        }
    }
}

