/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers.sorted;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.pinot.common.utils.Pairs;
import org.apache.pinot.core.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReaderContext;
import org.apache.pinot.core.segment.index.readers.SortedIndexReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class SortedIndexReaderImpl
implements SortedIndexReader<Context> {
    private final FixedByteValueReaderWriter _reader;
    private final int _cardinality;

    public SortedIndexReaderImpl(PinotDataBuffer dataBuffer, int cardinality) {
        Preconditions.checkState((dataBuffer.size() == (long)(2 * cardinality * 4) ? 1 : 0) != 0);
        this._reader = new FixedByteValueReaderWriter(dataBuffer);
        this._cardinality = cardinality;
    }

    @Override
    public Context createContext() {
        return new Context();
    }

    @Override
    public int getDictId(int docId, Context context) {
        if (this._cardinality == 1) {
            return 0;
        }
        int contextDictId = context._dictId;
        int contextStartOffset = context._startOffset;
        int contextEndOffset = context._endOffset;
        if (docId >= contextStartOffset) {
            if (docId <= contextEndOffset) {
                return contextDictId;
            }
            int nextDictId = contextDictId + 1;
            int nextEndOffset = this._reader.getInt(2 * nextDictId + 1);
            if (docId <= nextEndOffset) {
                context._dictId = nextDictId;
                context._startOffset = contextEndOffset + 1;
                context._endOffset = nextEndOffset;
                return nextDictId;
            }
        }
        int dictId = docId < contextStartOffset ? this.binarySearch(docId, 0, contextDictId - 1) : this.binarySearch(docId, contextDictId + 2, this._cardinality - 1);
        context._dictId = dictId;
        context._startOffset = this._reader.getInt(2 * dictId);
        context._endOffset = this._reader.getInt(2 * dictId + 1);
        return dictId;
    }

    private int binarySearch(int row, int low, int high) {
        while (low <= high) {
            int mid = (low + high) / 2;
            if (this._reader.getInt(2 * mid) <= row) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return high;
    }

    @Override
    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, Context context) {
        if (this._cardinality == 1) {
            for (int i = 0; i < length; ++i) {
                dictIdBuffer[i] = 0;
            }
        } else {
            for (int i = 0; i < length; ++i) {
                dictIdBuffer[i] = this.getDictId(docIds[i], context);
            }
        }
    }

    @Override
    public Pairs.IntPair getDocIds(int dictId) {
        return new Pairs.IntPair(this._reader.getInt(2 * dictId), this._reader.getInt(2 * dictId + 1));
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }

    public static class Context
    implements ForwardIndexReaderContext {
        private int _dictId = -1;
        private int _startOffset = -1;
        private int _endOffset = -1;

        @Override
        public void close() {
        }
    }
}

