/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers.forward;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.pinot.core.segment.index.readers.forward.BaseChunkSVForwardIndexReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedByteChunkSVForwardIndexReader
extends BaseChunkSVForwardIndexReader {
    private final int _chunkSize;

    public FixedByteChunkSVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        super(dataBuffer, valueType);
        this._chunkSize = this._numDocsPerChunk * this._lengthOfLongestEntry;
    }

    @Override
    @Nullable
    public BaseChunkSVForwardIndexReader.ChunkReaderContext createContext() {
        if (this._isCompressed) {
            return new BaseChunkSVForwardIndexReader.ChunkReaderContext(this._chunkSize);
        }
        return null;
    }

    @Override
    public int getInt(int docId, BaseChunkSVForwardIndexReader.ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId % this._numDocsPerChunk;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getInt(chunkRowId * 4);
        }
        return this._rawData.getInt(docId * 4);
    }

    @Override
    public long getLong(int docId, BaseChunkSVForwardIndexReader.ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId % this._numDocsPerChunk;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getLong(chunkRowId * 8);
        }
        return this._rawData.getLong(docId * 8);
    }

    @Override
    public float getFloat(int docId, BaseChunkSVForwardIndexReader.ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId % this._numDocsPerChunk;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getFloat(chunkRowId * 4);
        }
        return this._rawData.getFloat(docId * 4);
    }

    @Override
    public double getDouble(int docId, BaseChunkSVForwardIndexReader.ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId % this._numDocsPerChunk;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getDouble(chunkRowId * 8);
        }
        return this._rawData.getDouble(docId * 8);
    }
}

