/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers.forward;

import org.apache.pinot.core.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReaderContext;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBitSVForwardIndexReader
implements ForwardIndexReader<ForwardIndexReaderContext> {
    private final FixedBitIntReaderWriter _reader;

    public FixedBitSVForwardIndexReader(PinotDataBuffer dataBuffer, int numDocs, int numBitsPerValue) {
        this._reader = new FixedBitIntReaderWriter(dataBuffer, numDocs, numBitsPerValue);
    }

    @Override
    public boolean isDictionaryEncoded() {
        return true;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    @Override
    public int getDictId(int docId, ForwardIndexReaderContext context) {
        return this._reader.readInt(docId);
    }

    @Override
    public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, ForwardIndexReaderContext context) {
        for (int i = 0; i < length; ++i) {
            dictIdBuffer[i] = this._reader.readInt(docIds[i]);
        }
    }

    @Override
    public void close() {
        this._reader.close();
    }
}

