/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers.forward;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.core.io.compression.ChunkCompressorFactory;
import org.apache.pinot.core.io.compression.ChunkDecompressor;
import org.apache.pinot.core.io.writer.impl.BaseChunkSVForwardIndexWriter;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReaderContext;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.util.CleanerUtil;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkSVForwardIndexReader
implements ForwardIndexReader<ChunkReaderContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkSVForwardIndexReader.class);
    protected final PinotDataBuffer _dataBuffer;
    protected final FieldSpec.DataType _valueType;
    protected final int _numChunks;
    protected final int _numDocsPerChunk;
    protected final int _lengthOfLongestEntry;
    protected final boolean _isCompressed;
    protected final ChunkDecompressor _chunkDecompressor;
    protected final PinotDataBuffer _dataHeader;
    protected final int _headerEntryChunkOffsetSize;
    protected final PinotDataBuffer _rawData;

    public BaseChunkSVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        this._dataBuffer = dataBuffer;
        this._valueType = valueType;
        int headerOffset = 0;
        int version = this._dataBuffer.getInt(headerOffset);
        this._numChunks = this._dataBuffer.getInt(headerOffset += 4);
        this._numDocsPerChunk = this._dataBuffer.getInt(headerOffset += 4);
        this._lengthOfLongestEntry = this._dataBuffer.getInt(headerOffset += 4);
        if (valueType.isFixedWidth()) {
            Preconditions.checkState((this._lengthOfLongestEntry == valueType.size() ? 1 : 0) != 0);
        }
        int dataHeaderStart = headerOffset += 4;
        if (version > 1) {
            this._dataBuffer.getInt(headerOffset);
            ChunkCompressorFactory.CompressionType compressionType = ChunkCompressorFactory.CompressionType.values()[this._dataBuffer.getInt(headerOffset += 4)];
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(compressionType);
            this._isCompressed = !compressionType.equals((Object)ChunkCompressorFactory.CompressionType.PASS_THROUGH);
            dataHeaderStart = this._dataBuffer.getInt(headerOffset += 4);
        } else {
            this._isCompressed = true;
            this._chunkDecompressor = ChunkCompressorFactory.getDecompressor(ChunkCompressorFactory.CompressionType.SNAPPY);
        }
        this._headerEntryChunkOffsetSize = BaseChunkSVForwardIndexWriter.getHeaderEntryChunkOffsetSize(version);
        int dataHeaderLength = this._numChunks * this._headerEntryChunkOffsetSize;
        int rawDataStart = dataHeaderStart + dataHeaderLength;
        this._dataHeader = this._dataBuffer.view(dataHeaderStart, rawDataStart);
        this._rawData = this._dataBuffer.view(rawDataStart, this._dataBuffer.size());
    }

    protected ByteBuffer getChunkBuffer(int docId, ChunkReaderContext context) {
        int chunkSize;
        int chunkId = docId / this._numDocsPerChunk;
        if (context.getChunkId() == chunkId) {
            return context.getChunkBuffer();
        }
        long chunkPosition = this.getChunkPosition(chunkId);
        if (chunkId == this._numChunks - 1) {
            chunkSize = (int)(this._dataBuffer.size() - chunkPosition);
        } else {
            long nextChunkOffset = this.getChunkPosition(chunkId + 1);
            chunkSize = (int)(nextChunkOffset - chunkPosition);
        }
        ByteBuffer decompressedBuffer = context.getChunkBuffer();
        decompressedBuffer.clear();
        try {
            this._chunkDecompressor.decompress(this._dataBuffer.toDirectByteBuffer(chunkPosition, chunkSize), decompressedBuffer);
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while decompressing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        context.setChunkId(chunkId);
        return decompressedBuffer;
    }

    protected long getChunkPosition(int chunkId) {
        if (this._headerEntryChunkOffsetSize == 4) {
            return this._dataHeader.getInt(chunkId * this._headerEntryChunkOffsetSize);
        }
        return this._dataHeader.getLong(chunkId * this._headerEntryChunkOffsetSize);
    }

    @Override
    public boolean isDictionaryEncoded() {
        return false;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    @Override
    public void close() {
    }

    public static class ChunkReaderContext
    implements ForwardIndexReaderContext {
        private final ByteBuffer _chunkBuffer;
        private int _chunkId;

        public ChunkReaderContext(int maxChunkSize) {
            this._chunkBuffer = ByteBuffer.allocateDirect(maxChunkSize);
            this._chunkId = -1;
        }

        public ByteBuffer getChunkBuffer() {
            return this._chunkBuffer;
        }

        public int getChunkId() {
            return this._chunkId;
        }

        public void setChunkId(int chunkId) {
            this._chunkId = chunkId;
        }

        @Override
        public void close() throws IOException {
            if (CleanerUtil.UNMAP_SUPPORTED) {
                CleanerUtil.getCleaner().freeBuffer(this._chunkBuffer);
            }
        }
    }
}

