/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers.bloom;

import org.apache.pinot.core.segment.index.readers.bloom.BaseGuavaBloomFilterReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public class OnHeapGuavaBloomFilterReader
extends BaseGuavaBloomFilterReader {
    private final long[] _data;

    public OnHeapGuavaBloomFilterReader(PinotDataBuffer dataBuffer) {
        super(dataBuffer);
        int numLongs = (int)(this._numBits / 64L);
        this._data = new long[numLongs];
        for (int i = 0; i < numLongs; ++i) {
            this._data[i] = this._valueBuffer.getLong(i * 8);
        }
    }

    @Override
    public boolean mightContain(long hash1, long hash2) {
        long combinedHash = hash1;
        for (int i = 0; i < this._numHashFunctions; ++i) {
            long bitIndex = (combinedHash & Long.MAX_VALUE) % this._numBits;
            if ((this._data[(int)(bitIndex >>> 6)] & 1L << (int)bitIndex) == 0L) {
                return false;
            }
            combinedHash += hash2;
        }
        return true;
    }
}

