/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers.bloom;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import org.apache.pinot.core.segment.index.readers.BloomFilterReader;
import org.apache.pinot.core.segment.index.readers.bloom.GuavaBloomFilterReaderUtils;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;

public abstract class BaseGuavaBloomFilterReader
implements BloomFilterReader {
    private static final int STRATEGY_ORDINAL_OFFSET = 0;
    private static final int NUM_HASH_FUNCTIONS_OFFSET = 1;
    private static final int NUM_LONGS_OFFSET = 2;
    private static final int HEADER_SIZE = 6;
    protected final int _numHashFunctions;
    protected final long _numBits;
    protected final PinotDataBuffer _valueBuffer;

    public BaseGuavaBloomFilterReader(PinotDataBuffer dataBuffer) {
        byte strategyOrdinal = dataBuffer.getByte(0);
        Preconditions.checkState((strategyOrdinal == 1 ? 1 : 0) != 0, (String)"Unsupported strategy ordinal: %s", (int)strategyOrdinal);
        this._numHashFunctions = dataBuffer.getByte(1) & 0xFF;
        this._numBits = (long)dataBuffer.getInt(2) * 64L;
        this._valueBuffer = dataBuffer.view(6L, dataBuffer.size());
    }

    @Override
    public boolean mightContain(String value) {
        byte[] hash = GuavaBloomFilterReaderUtils.hash(value);
        long hash1 = Longs.fromBytes((byte)hash[7], (byte)hash[6], (byte)hash[5], (byte)hash[4], (byte)hash[3], (byte)hash[2], (byte)hash[1], (byte)hash[0]);
        long hash2 = Longs.fromBytes((byte)hash[15], (byte)hash[14], (byte)hash[13], (byte)hash[12], (byte)hash[11], (byte)hash[10], (byte)hash[9], (byte)hash[8]);
        return this.mightContain(hash1, hash2);
    }

    @Override
    public void close() {
    }
}

