/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;

public class OnHeapStringDictionary
extends OnHeapDictionary {
    private final byte _paddingByte;
    private final String[] _unpaddedStrings;
    private final Object2IntOpenHashMap<String> _unPaddedStringToIdMap;
    private final String[] _paddedStrings;

    public OnHeapStringDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue, byte paddingByte) {
        super(dataBuffer, length, numBytesPerValue, paddingByte);
        int i;
        this._paddingByte = paddingByte;
        byte[] buffer = new byte[numBytesPerValue];
        this._unpaddedStrings = new String[length];
        this._unPaddedStringToIdMap = new Object2IntOpenHashMap(length);
        this._unPaddedStringToIdMap.defaultReturnValue(-1);
        for (i = 0; i < length; ++i) {
            String unpaddedString;
            this._unpaddedStrings[i] = unpaddedString = this.getUnpaddedString(i, buffer);
            this._unPaddedStringToIdMap.put((Object)unpaddedString, i);
        }
        if (paddingByte == 0) {
            this._paddedStrings = null;
        } else {
            this._paddedStrings = new String[length];
            for (i = 0; i < length; ++i) {
                this._paddedStrings[i] = this.getPaddedString(i, buffer);
            }
        }
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        int index = this._unPaddedStringToIdMap.getInt((Object)stringValue);
        if (index != -1) {
            return index;
        }
        return this._paddingByte == 0 ? Arrays.binarySearch(this._unpaddedStrings, stringValue) : Arrays.binarySearch(this._paddedStrings, this.padString(stringValue));
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._unPaddedStringToIdMap.getInt((Object)stringValue);
    }

    @Override
    public String get(int dictId) {
        return this._unpaddedStrings[dictId];
    }

    @Override
    public int getIntValue(int dictId) {
        return Integer.parseInt(this._unpaddedStrings[dictId]);
    }

    @Override
    public long getLongValue(int dictId) {
        return Long.parseLong(this._unpaddedStrings[dictId]);
    }

    @Override
    public float getFloatValue(int dictId) {
        return Float.parseFloat(this._unpaddedStrings[dictId]);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return Double.parseDouble(this._unpaddedStrings[dictId]);
    }

    @Override
    public String getStringValue(int dictId) {
        return this._unpaddedStrings[dictId];
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return BytesUtils.toBytes((String)this._unpaddedStrings[dictId]);
    }
}

