/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import java.util.Arrays;
import org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class OnHeapLongDictionary
extends OnHeapDictionary {
    private final Long2IntOpenHashMap _valToDictId;
    private final long[] _dictIdToVal;

    public OnHeapLongDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
        this._valToDictId = new Long2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new long[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            long value;
            this._dictIdToVal[dictId] = value = this.getLong(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        long longValue = Long.parseLong(stringValue);
        int index = this._valToDictId.get(longValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, longValue);
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._valToDictId.get(Long.parseLong(stringValue));
    }

    @Override
    public Long get(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this._dictIdToVal[dictId];
    }

    @Override
    public long getLongValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public float getFloatValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public String getStringValue(int dictId) {
        return Long.toString(this._dictIdToVal[dictId]);
    }
}

