/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import java.util.Arrays;
import org.apache.pinot.core.segment.index.readers.OnHeapDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class OnHeapFloatDictionary
extends OnHeapDictionary {
    private final Float2IntOpenHashMap _valToDictId;
    private final float[] _dictIdToVal;

    public OnHeapFloatDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4, (byte)0);
        this._valToDictId = new Float2IntOpenHashMap(length);
        this._valToDictId.defaultReturnValue(-1);
        this._dictIdToVal = new float[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            float value;
            this._dictIdToVal[dictId] = value = this.getFloat(dictId);
            this._valToDictId.put(value, dictId);
        }
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        float floatValue = Float.parseFloat(stringValue);
        int index = this._valToDictId.get(floatValue);
        return index != -1 ? index : Arrays.binarySearch(this._dictIdToVal, floatValue);
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.FLOAT;
    }

    @Override
    public int indexOf(String stringValue) {
        return this._valToDictId.get(Float.parseFloat(stringValue));
    }

    @Override
    public Float get(int dictId) {
        return Float.valueOf(this._dictIdToVal[dictId]);
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this._dictIdToVal[dictId];
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this._dictIdToVal[dictId];
    }

    @Override
    public float getFloatValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    @Override
    public String getStringValue(int dictId) {
        return Float.toString(this._dictIdToVal[dictId]);
    }
}

