/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class LongDictionary
extends BaseImmutableDictionary {
    public LongDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Long.parseLong(stringValue));
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.LONG;
    }

    @Override
    public Long get(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this.getLong(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this.getLong(dictId);
    }

    @Override
    public String getStringValue(int dictId) {
        return Long.toString(this.getLong(dictId));
    }
}

