/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class FloatDictionary
extends BaseImmutableDictionary {
    public FloatDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4, (byte)0);
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Float.parseFloat(stringValue));
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.FLOAT;
    }

    @Override
    public Float get(int dictId) {
        return Float.valueOf(this.getFloat(dictId));
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this.getFloat(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this.getFloat(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return this.getFloat(dictId);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this.getFloat(dictId);
    }

    @Override
    public String getStringValue(int dictId) {
        return Float.toString(this.getFloat(dictId));
    }
}

