/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class DoubleDictionary
extends BaseImmutableDictionary {
    public DoubleDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 8, (byte)0);
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Double.parseDouble(stringValue));
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.DOUBLE;
    }

    @Override
    public Double get(int dictId) {
        return this.getDouble(dictId);
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this.getDouble(dictId);
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this.getDouble(dictId);
    }

    @Override
    public float getFloatValue(int dictId) {
        return (float)this.getDouble(dictId);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this.getDouble(dictId);
    }

    @Override
    public String getStringValue(int dictId) {
        return Double.toString(this.getDouble(dictId));
    }
}

