/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import org.apache.pinot.spi.data.FieldSpec;

public interface Dictionary
extends Closeable {
    public static final int NULL_VALUE_INDEX = -1;

    public boolean isSorted();

    public FieldSpec.DataType getValueType();

    public int length();

    public int indexOf(String var1);

    public int insertionIndexOf(String var1);

    public IntSet getDictIdsInRange(String var1, String var2, boolean var3, boolean var4);

    public int compare(int var1, int var2);

    public Comparable getMinVal();

    public Comparable getMaxVal();

    public Object getSortedValues();

    public Object get(int var1);

    public int getIntValue(int var1);

    public long getLongValue(int var1);

    public float getFloatValue(int var1);

    public double getDoubleValue(int var1);

    public String getStringValue(int var1);

    default public byte[] getBytesValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    default public void readIntValues(int[] dictIds, int length, int[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getIntValue(dictIds[i]);
        }
    }

    default public void readLongValues(int[] dictIds, int length, long[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getLongValue(dictIds[i]);
        }
    }

    default public void readFloatValues(int[] dictIds, int length, float[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getFloatValue(dictIds[i]);
        }
    }

    default public void readDoubleValues(int[] dictIds, int length, double[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getDoubleValue(dictIds[i]);
        }
    }

    default public void readStringValues(int[] dictIds, int length, String[] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getStringValue(dictIds[i]);
        }
    }

    default public void readBytesValues(int[] dictIds, int length, byte[][] outValues) {
        for (int i = 0; i < length; ++i) {
            outValues[i] = this.getBytesValue(dictIds[i]);
        }
    }
}

