/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;

public class ConstantValueStringDictionary
extends BaseImmutableDictionary {
    private final String _value;

    public ConstantValueStringDictionary(String value) {
        super(1);
        this._value = value;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.STRING;
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        int result = stringValue.compareTo(this._value);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return -2;
        }
        return 0;
    }

    public String getMinVal() {
        return this._value;
    }

    public String getMaxVal() {
        return this._value;
    }

    public String[] getSortedValues() {
        return new String[]{this._value};
    }

    @Override
    public String get(int dictId) {
        return this._value;
    }

    @Override
    public int getIntValue(int dictId) {
        return Integer.parseInt(this._value);
    }

    @Override
    public long getLongValue(int dictId) {
        return Long.parseLong(this._value);
    }

    @Override
    public float getFloatValue(int dictId) {
        return Float.parseFloat(this._value);
    }

    @Override
    public double getDoubleValue(int dictId) {
        return Double.parseDouble(this._value);
    }

    @Override
    public String getStringValue(int dictId) {
        return this._value;
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return BytesUtils.toBytes((String)this._value);
    }
}

