/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ConstantValueFloatDictionary
extends BaseImmutableDictionary {
    private final float _value;

    public ConstantValueFloatDictionary(float value) {
        super(1);
        this._value = value;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.FLOAT;
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        float floatValue = Float.parseFloat(stringValue);
        if (floatValue < this._value) {
            return -1;
        }
        if (floatValue > this._value) {
            return -2;
        }
        return 0;
    }

    @Override
    public Float getMinVal() {
        return Float.valueOf(this._value);
    }

    @Override
    public Float getMaxVal() {
        return Float.valueOf(this._value);
    }

    public float[] getSortedValues() {
        return new float[]{this._value};
    }

    @Override
    public Float get(int dictId) {
        return Float.valueOf(this._value);
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this._value;
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this._value;
    }

    @Override
    public float getFloatValue(int dictId) {
        return this._value;
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._value;
    }

    @Override
    public String getStringValue(int dictId) {
        return Float.toString(this._value);
    }
}

