/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ConstantValueDoubleDictionary
extends BaseImmutableDictionary {
    private final double _value;

    public ConstantValueDoubleDictionary(double value) {
        super(1);
        this._value = value;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.DOUBLE;
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        double doubleValue = Double.parseDouble(stringValue);
        if (doubleValue < this._value) {
            return -1;
        }
        if (doubleValue > this._value) {
            return -2;
        }
        return 0;
    }

    @Override
    public Double getMinVal() {
        return this._value;
    }

    @Override
    public Double getMaxVal() {
        return this._value;
    }

    public double[] getSortedValues() {
        return new double[]{this._value};
    }

    @Override
    public Double get(int dictId) {
        return this._value;
    }

    @Override
    public int getIntValue(int dictId) {
        return (int)this._value;
    }

    @Override
    public long getLongValue(int dictId) {
        return (long)this._value;
    }

    @Override
    public float getFloatValue(int dictId) {
        return (float)this._value;
    }

    @Override
    public double getDoubleValue(int dictId) {
        return this._value;
    }

    @Override
    public String getStringValue(int dictId) {
        return Double.toString(this._value);
    }
}

