/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class ConstantValueBytesDictionary
extends BaseImmutableDictionary {
    private final byte[] _value;

    public ConstantValueBytesDictionary(byte[] value) {
        super(1);
        this._value = value;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        int result = ByteArray.compare((byte[])BytesUtils.toBytes((String)stringValue), (byte[])this._value);
        if (result < 0) {
            return -1;
        }
        if (result > 0) {
            return -2;
        }
        return 0;
    }

    public ByteArray getMinVal() {
        return new ByteArray(this._value);
    }

    public ByteArray getMaxVal() {
        return new ByteArray(this._value);
    }

    @Override
    public Object getSortedValues() {
        return new ByteArray[]{new ByteArray(this._value)};
    }

    public byte[] get(int dictId) {
        return this._value;
    }

    @Override
    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this._value);
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return this._value;
    }
}

