/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import org.apache.pinot.core.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class BytesDictionary
extends BaseImmutableDictionary {
    public BytesDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue) {
        super(dataBuffer, length, numBytesPerValue, (byte)0);
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    @Override
    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(BytesUtils.toBytes((String)stringValue));
    }

    public ByteArray getMinVal() {
        return new ByteArray(this.getBytes(0));
    }

    public ByteArray getMaxVal() {
        return new ByteArray(this.getBytes(this.length() - 1));
    }

    public byte[] get(int dictId) {
        return this.getBytes(dictId);
    }

    @Override
    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this.getBytes(dictId));
    }

    @Override
    public byte[] getBytesValue(int dictId) {
        return this.getBytes(dictId);
    }
}

