/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.readers;

import com.google.common.base.Preconditions;
import java.lang.ref.SoftReference;
import org.apache.pinot.core.segment.index.readers.InvertedIndexReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapInvertedIndexReader
implements InvertedIndexReader<ImmutableRoaringBitmap> {
    public static final Logger LOGGER = LoggerFactory.getLogger(BitmapInvertedIndexReader.class);
    private final PinotDataBuffer _dataBuffer;
    private final int _numBitmaps;
    private volatile SoftReference<SoftReference<ImmutableRoaringBitmap>[]> _bitmaps;

    public BitmapInvertedIndexReader(PinotDataBuffer dataBuffer, int cardinality) {
        this._dataBuffer = dataBuffer;
        this._numBitmaps = cardinality;
        int lastOffset = this._dataBuffer.getInt(this._numBitmaps * 4);
        Preconditions.checkState(((long)lastOffset == this._dataBuffer.size() ? 1 : 0) != 0, (Object)("The last offset should be equal to buffer size! Current lastOffset: " + lastOffset + ", buffer size: " + this._dataBuffer.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableRoaringBitmap getDocIds(int dictId) {
        ImmutableRoaringBitmap value;
        SoftReference[] bitmapArrayReference = null;
        if (this._bitmaps != null) {
            bitmapArrayReference = this._bitmaps.get();
            if (bitmapArrayReference != null) {
                SoftReference bitmapReference = bitmapArrayReference[dictId];
                if (bitmapReference != null && (value = (ImmutableRoaringBitmap)bitmapReference.get()) != null) {
                    return value;
                }
            } else {
                bitmapArrayReference = new SoftReference[this._numBitmaps];
                this._bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
            }
        } else {
            bitmapArrayReference = new SoftReference[this._numBitmaps];
            this._bitmaps = new SoftReference<SoftReference[]>(bitmapArrayReference);
        }
        BitmapInvertedIndexReader bitmapInvertedIndexReader = this;
        synchronized (bitmapInvertedIndexReader) {
            if (bitmapArrayReference[dictId] == null || bitmapArrayReference[dictId].get() == null) {
                value = this.buildRoaringBitmapForIndex(dictId);
                bitmapArrayReference[dictId] = new SoftReference<ImmutableRoaringBitmap>(value);
            } else {
                value = (ImmutableRoaringBitmap)bitmapArrayReference[dictId].get();
            }
            return value;
        }
    }

    private synchronized ImmutableRoaringBitmap buildRoaringBitmapForIndex(int index) {
        int currentOffset = this.getOffset(index);
        int bufferLength = this.getOffset(index + 1) - currentOffset;
        return new ImmutableRoaringBitmap(this._dataBuffer.toDirectByteBuffer(currentOffset, bufferLength));
    }

    private int getOffset(int index) {
        return this._dataBuffer.getInt(index * 4);
    }

    @Override
    public void close() {
    }
}

