/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadata;
import org.apache.pinot.core.segment.store.SegmentDirectoryPaths;
import org.apache.pinot.core.startree.v2.StarTreeV2Constants;
import org.apache.pinot.core.startree.v2.StarTreeV2Metadata;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMetadataImpl
implements SegmentMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMetadataImpl.class);
    private final File _indexDir;
    private final Map<String, ColumnMetadata> _columnMetadataMap;
    private String _tableName;
    private String _segmentName;
    private final Set<String> _allColumns;
    private final Schema _schema;
    private long _crc = Long.MIN_VALUE;
    private long _creationTime = Long.MIN_VALUE;
    private String _timeColumn;
    private TimeUnit _timeUnit;
    private Interval _timeInterval;
    private Duration _timeGranularity;
    private long _pushTime = Long.MIN_VALUE;
    private long _refreshTime = Long.MIN_VALUE;
    private long _lastIndexedTime = Long.MIN_VALUE;
    private long _latestIngestionTime = Long.MIN_VALUE;
    private SegmentVersion _segmentVersion;
    private List<StarTreeV2Metadata> _starTreeV2MetadataList;
    private String _creatorName;
    private char _paddingCharacter = '\u0000';
    private int _totalDocs;
    private long _segmentStartTime;
    private long _segmentEndTime;

    public SegmentMetadataImpl(File indexDir) throws IOException {
        this._indexDir = indexDir;
        PropertiesConfiguration segmentMetadataPropertiesConfiguration = SegmentMetadataImpl.getPropertiesConfiguration(indexDir);
        this._columnMetadataMap = new HashMap<String, ColumnMetadata>();
        this._allColumns = new HashSet<String>();
        this._schema = new Schema();
        this.init(segmentMetadataPropertiesConfiguration);
        File creationMetaFile = SegmentDirectoryPaths.findCreationMetaFile(indexDir);
        if (creationMetaFile != null) {
            this.loadCreationMeta(creationMetaFile);
        }
        this.setTimeInfo(segmentMetadataPropertiesConfiguration);
        this._totalDocs = segmentMetadataPropertiesConfiguration.getInt("segment.total.docs");
    }

    public SegmentMetadataImpl(RealtimeSegmentZKMetadata segmentMetadata, Schema schema) {
        this._indexDir = null;
        PropertiesConfiguration segmentMetadataPropertiesConfiguration = new PropertiesConfiguration();
        segmentMetadataPropertiesConfiguration.addProperty("creator.version", null);
        segmentMetadataPropertiesConfiguration.addProperty("segment.padding.character", (Object)Character.valueOf('\u0000'));
        segmentMetadataPropertiesConfiguration.addProperty("segment.start.time", (Object)Long.toString(segmentMetadata.getStartTime()));
        segmentMetadataPropertiesConfiguration.addProperty("segment.end.time", (Object)Long.toString(segmentMetadata.getEndTime()));
        segmentMetadataPropertiesConfiguration.addProperty("segment.table.name", (Object)segmentMetadata.getTableName());
        TimeUnit timeUnit = segmentMetadata.getTimeUnit();
        if (timeUnit != null) {
            segmentMetadataPropertiesConfiguration.addProperty("segment.time.unit", (Object)timeUnit.toString());
        } else {
            segmentMetadataPropertiesConfiguration.addProperty("segment.time.unit", null);
        }
        segmentMetadataPropertiesConfiguration.addProperty("segment.total.docs", (Object)segmentMetadata.getTotalDocs());
        this._crc = segmentMetadata.getCrc();
        this._creationTime = segmentMetadata.getCreationTime();
        this.setTimeInfo(segmentMetadataPropertiesConfiguration);
        this._columnMetadataMap = null;
        this._tableName = segmentMetadata.getTableName();
        this._segmentName = segmentMetadata.getSegmentName();
        this._allColumns = schema.getColumnNames();
        this._schema = schema;
        this._totalDocs = segmentMetadataPropertiesConfiguration.getInt("segment.total.docs");
    }

    public static PropertiesConfiguration getPropertiesConfiguration(File indexDir) {
        File metadataFile = SegmentDirectoryPaths.findMetadataFile(indexDir);
        Preconditions.checkNotNull((Object)metadataFile, (String)"Cannot find segment metadata file under directory: %s", (Object)indexDir);
        return CommonsConfigurationUtils.fromFile((File)metadataFile);
    }

    private void setTimeInfo(PropertiesConfiguration segmentMetadataPropertiesConfiguration) {
        this._timeColumn = segmentMetadataPropertiesConfiguration.getString("segment.time.column.name");
        if (segmentMetadataPropertiesConfiguration.containsKey("segment.start.time") && segmentMetadataPropertiesConfiguration.containsKey("segment.end.time") && segmentMetadataPropertiesConfiguration.containsKey("segment.time.unit")) {
            try {
                this._timeUnit = TimeUtils.timeUnitFromString((String)segmentMetadataPropertiesConfiguration.getString("segment.time.unit"));
                assert (this._timeUnit != null);
                this._timeGranularity = new Duration(this._timeUnit.toMillis(1L));
                String startTimeString = segmentMetadataPropertiesConfiguration.getString("segment.start.time");
                String endTimeString = segmentMetadataPropertiesConfiguration.getString("segment.end.time");
                this._segmentStartTime = Long.parseLong(startTimeString);
                this._segmentEndTime = Long.parseLong(endTimeString);
                this._timeInterval = new Interval(this._timeUnit.toMillis(this._segmentStartTime), this._timeUnit.toMillis(this._segmentEndTime), DateTimeZone.UTC);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while setting time interval and granularity", (Throwable)e);
                this._timeInterval = null;
                this._timeGranularity = null;
                this._segmentStartTime = Long.MAX_VALUE;
                this._segmentEndTime = Long.MIN_VALUE;
            }
        }
    }

    private void loadCreationMeta(File crcFile) throws IOException {
        if (crcFile.exists()) {
            DataInputStream ds = new DataInputStream(new FileInputStream(crcFile));
            this._crc = ds.readLong();
            this._creationTime = ds.readLong();
            ds.close();
        }
    }

    public Set<String> getAllColumns() {
        return this._allColumns;
    }

    private void init(PropertiesConfiguration segmentMetadataPropertiesConfiguration) {
        if (segmentMetadataPropertiesConfiguration.containsKey("creator.version")) {
            this._creatorName = segmentMetadataPropertiesConfiguration.getString("creator.version");
        }
        if (segmentMetadataPropertiesConfiguration.containsKey("segment.padding.character")) {
            String padding = segmentMetadataPropertiesConfiguration.getString("segment.padding.character");
            this._paddingCharacter = StringEscapeUtils.unescapeJava((String)padding).charAt(0);
        }
        String versionString = segmentMetadataPropertiesConfiguration.getString("segment.index.version", SegmentVersion.v1.toString());
        this._segmentVersion = SegmentVersion.valueOf(versionString);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.dimension.column.names"), this._allColumns);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.metric.column.names"), this._allColumns);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.time.column.name"), this._allColumns);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.datetime.column.names"), this._allColumns);
        this._tableName = segmentMetadataPropertiesConfiguration.getString("segment.table.name");
        this._segmentName = segmentMetadataPropertiesConfiguration.getString("segment.name");
        for (String column : this._allColumns) {
            ColumnMetadata columnMetadata = ColumnMetadata.fromPropertiesConfiguration(column, segmentMetadataPropertiesConfiguration);
            this._columnMetadataMap.put(column, columnMetadata);
            this._schema.addField(columnMetadata.getFieldSpec());
        }
        int starTreeV2Count = segmentMetadataPropertiesConfiguration.getInt("startree.v2.count", 0);
        if (starTreeV2Count > 0) {
            this._starTreeV2MetadataList = new ArrayList<StarTreeV2Metadata>(starTreeV2Count);
            for (int i = 0; i < starTreeV2Count; ++i) {
                this._starTreeV2MetadataList.add(new StarTreeV2Metadata(segmentMetadataPropertiesConfiguration.subset(StarTreeV2Constants.MetadataKey.getStarTreePrefix(i))));
            }
        }
    }

    private static void addPhysicalColumns(List src, Collection<String> dest) {
        for (Object o : src) {
            String column = o.toString();
            if (column.isEmpty() || column.charAt(0) == '$' || dest.contains(column)) continue;
            dest.add(column);
        }
    }

    public ColumnMetadata getColumnMetadataFor(String column) {
        return this._columnMetadataMap.get(column);
    }

    public Map<String, ColumnMetadata> getColumnMetadataMap() {
        return this._columnMetadataMap;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public String getTimeColumn() {
        return this._timeColumn;
    }

    @Override
    public long getStartTime() {
        return this._segmentStartTime;
    }

    @Override
    public long getEndTime() {
        return this._segmentEndTime;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    @Override
    public Duration getTimeGranularity() {
        return this._timeGranularity;
    }

    @Override
    public Interval getTimeInterval() {
        return this._timeInterval;
    }

    @Override
    public String getCrc() {
        return String.valueOf(this._crc);
    }

    @Override
    public String getVersion() {
        return this._segmentVersion.toString();
    }

    public SegmentVersion getSegmentVersion() {
        return this._segmentVersion;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public String getShardingKey() {
        return null;
    }

    @Override
    public int getTotalDocs() {
        return this._totalDocs;
    }

    @Override
    public File getIndexDir() {
        return this._indexDir;
    }

    @Override
    public String getName() {
        return this._segmentName;
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            result.append("  ");
            try {
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Caught exception while trying to access field {}", (Object)field, (Object)ex);
                }
                result.append("ERROR");
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    @Override
    public long getIndexCreationTime() {
        return this._creationTime;
    }

    @Override
    public long getPushTime() {
        return this._pushTime;
    }

    @Override
    public long getRefreshTime() {
        return this._refreshTime;
    }

    @Override
    public long getLastIndexedTimestamp() {
        return this._lastIndexedTime;
    }

    @Override
    public long getLatestIngestionTimestamp() {
        return this._latestIngestionTime;
    }

    @Override
    public boolean hasDictionary(String columnName) {
        return this._columnMetadataMap.get(columnName).hasDictionary();
    }

    @Override
    public boolean close() {
        return false;
    }

    public List<StarTreeV2Metadata> getStarTreeV2MetadataList() {
        return this._starTreeV2MetadataList;
    }

    @Override
    public String getForwardIndexFileName(String column) {
        ColumnMetadata columnMetadata = this.getColumnMetadataFor(column);
        StringBuilder fileNameBuilder = new StringBuilder(column);
        if (columnMetadata.isSingleValue()) {
            if (!columnMetadata.hasDictionary()) {
                fileNameBuilder.append(".sv.raw.fwd");
            } else if (columnMetadata.isSorted()) {
                fileNameBuilder.append(".sv.sorted.fwd");
            } else {
                fileNameBuilder.append(".sv.unsorted.fwd");
            }
        } else {
            fileNameBuilder.append(".mv.fwd");
        }
        return fileNameBuilder.toString();
    }

    @Override
    public String getDictionaryFileName(String column) {
        return column + ".dict";
    }

    @Override
    public String getBitmapInvertedIndexFileName(String column) {
        return column + ".bitmap.inv";
    }

    @Override
    public String getBitmapRangeIndexFileName(String column) {
        return column + ".bitmap.range";
    }

    @Override
    public String getBloomFilterFileName(String column) {
        return column + ".bloom";
    }

    @Override
    public String getNullValueVectorFileName(String column) {
        return column + ".bitmap.nullvalue";
    }

    @Override
    @Nullable
    public String getCreatorName() {
        return this._creatorName;
    }

    @Override
    public char getPaddingCharacter() {
        return this._paddingCharacter;
    }

    public JsonNode toJson(@Nullable Set<String> columnFilter) {
        ObjectNode segmentMetadata = JsonUtils.newObjectNode();
        segmentMetadata.put("segmentName", this._segmentName);
        segmentMetadata.put("schemaName", this._schema != null ? this._schema.getSchemaName() : null);
        segmentMetadata.put("crc", this._crc);
        segmentMetadata.put("creationTimeMillis", this._creationTime);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS' UTC'");
        dateFormat.setTimeZone(timeZone);
        String creationTimeStr = this._creationTime != Long.MIN_VALUE ? dateFormat.format(new Date(this._creationTime)) : null;
        segmentMetadata.put("creationTimeReadable", creationTimeStr);
        segmentMetadata.put("timeGranularitySec", this._timeGranularity != null ? Long.valueOf(this._timeGranularity.getStandardSeconds()) : null);
        if (this._timeInterval == null) {
            segmentMetadata.set("startTimeMillis", null);
            segmentMetadata.set("startTimeReadable", null);
            segmentMetadata.set("endTimeMillis", null);
            segmentMetadata.set("endTimeReadable", null);
        } else {
            segmentMetadata.put("startTimeMillis", this._timeInterval.getStartMillis());
            segmentMetadata.put("startTimeReadable", this._timeInterval.getStart().toString());
            segmentMetadata.put("endTimeMillis", this._timeInterval.getEndMillis());
            segmentMetadata.put("endTimeReadable", this._timeInterval.getEnd().toString());
        }
        segmentMetadata.put("pushTimeMillis", this._pushTime);
        String pushTimeStr = this._pushTime != Long.MIN_VALUE ? dateFormat.format(new Date(this._pushTime)) : null;
        segmentMetadata.put("pushTimeReadable", pushTimeStr);
        segmentMetadata.put("refreshTimeMillis", this._refreshTime);
        String refreshTimeStr = this._refreshTime != Long.MIN_VALUE ? dateFormat.format(new Date(this._refreshTime)) : null;
        segmentMetadata.put("refreshTimeReadable", refreshTimeStr);
        segmentMetadata.put("segmentVersion", this._segmentVersion.toString());
        segmentMetadata.put("creatorName", this._creatorName);
        segmentMetadata.put("paddingCharacter", String.valueOf(this._paddingCharacter));
        ArrayNode columnsMetadata = JsonUtils.newArrayNode();
        for (String column : this._allColumns) {
            if (columnFilter != null && !columnFilter.contains(column)) continue;
            columnsMetadata.add(JsonUtils.objectToJsonNode((Object)this._columnMetadataMap.get(column)));
        }
        segmentMetadata.set("columns", (JsonNode)columnsMetadata);
        return segmentMetadata;
    }
}

