/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.pinot.common.metadata.segment.ColumnPartitionMetadata;
import org.apache.pinot.core.data.partition.PartitionFunction;
import org.apache.pinot.core.data.partition.PartitionFunctionFactory;
import org.apache.pinot.core.segment.creator.TextIndexType;
import org.apache.pinot.core.segment.creator.impl.V1Constants;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(ColumnMetadata.class);
    private final FieldSpec fieldSpec;
    private final String columnName;
    private final int cardinality;
    private final int totalDocs;
    private final FieldSpec.DataType dataType;
    private final int bitsPerElement;
    private final int columnMaxLength;
    private final FieldSpec.FieldType fieldType;
    private final boolean isSorted;
    @JsonProperty
    private final boolean containsNulls;
    @JsonProperty
    private final boolean hasDictionary;
    @JsonProperty
    private final boolean hasInvertedIndex;
    private final boolean isSingleValue;
    private final boolean isVirtual;
    private final int maxNumberOfMultiValues;
    private final int totalNumberOfEntries;
    private final boolean isAutoGenerated;
    private final String defaultNullValueString;
    private final TimeUnit timeUnit;
    private final char paddingCharacter;
    private final Comparable minValue;
    private final Comparable maxValue;
    private final PartitionFunction partitionFunction;
    private final int numPartitions;
    private final Set<Integer> _partitions;
    private final String dateTimeFormat;
    private final String dateTimeGranularity;
    private final TextIndexType textIndexType;

    public static ColumnMetadata fromPropertiesConfiguration(String column, PropertiesConfiguration config) {
        String partitionFunctionName;
        String dateTimeGranularity;
        Builder builder = new Builder();
        builder.setColumnName(column);
        builder.setCardinality(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "cardinality")));
        int totalDocs = config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "totalDocs"));
        builder.setTotalDocs(totalDocs);
        FieldSpec.DataType dataType = FieldSpec.DataType.valueOf((String)config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "dataType")).toUpperCase());
        builder.setDataType(dataType);
        builder.setBitsPerElement(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "bitsPerElement")));
        builder.setColumnMaxLength(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "lengthOfEachEntry")));
        builder.setFieldType(FieldSpec.FieldType.valueOf((String)config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "columnType")).toUpperCase()));
        builder.setIsSorted(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "isSorted")));
        builder.setContainsNulls(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasNullValue")));
        builder.setHasDictionary(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasDictionary"), true));
        builder.setHasInvertedIndex(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "hasInvertedIndex")));
        builder.setSingleValue(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "isSingleValues")));
        builder.setMaxNumberOfMultiValues(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "maxNumberOfMultiValues")));
        builder.setTotalNumberOfEntries(config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "totalNumberOfEntries")));
        builder.setAutoGenerated(config.getBoolean(V1Constants.MetadataKeys.Column.getKeyFor(column, "isAutoGenerated"), false));
        builder.setDefaultNullValueString(config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "defaultNullValue"), null));
        builder.setTimeUnit(TimeUnit.valueOf(config.getString("segment.time.unit", "DAYS").toUpperCase()));
        builder.setTextIndexType(config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "textIndexType"), TextIndexType.NONE.name()));
        char paddingCharacter = '%';
        if (config.containsKey("segment.padding.character")) {
            String padding = config.getString("segment.padding.character");
            paddingCharacter = StringEscapeUtils.unescapeJava((String)padding).charAt(0);
        }
        builder.setPaddingCharacter(paddingCharacter);
        String dateTimeFormat = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeFormat"), null);
        if (dateTimeFormat != null) {
            builder.setDateTimeFormat(dateTimeFormat);
        }
        if ((dateTimeGranularity = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "datetimeGranularity"), null)) != null) {
            builder.setDateTimeGranularity(dateTimeGranularity);
        }
        String minString = (String)config.getProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "minValue"));
        String maxString = (String)config.getProperty(V1Constants.MetadataKeys.Column.getKeyFor(column, "maxValue"));
        if (minString != null && maxString != null) {
            switch (dataType) {
                case INT: {
                    builder.setMinValue(Integer.valueOf(minString));
                    builder.setMaxValue(Integer.valueOf(maxString));
                    break;
                }
                case LONG: {
                    builder.setMinValue(Long.valueOf(minString));
                    builder.setMaxValue(Long.valueOf(maxString));
                    break;
                }
                case FLOAT: {
                    builder.setMinValue(Float.valueOf(minString));
                    builder.setMaxValue(Float.valueOf(maxString));
                    break;
                }
                case DOUBLE: {
                    builder.setMinValue(Double.valueOf(minString));
                    builder.setMaxValue(Double.valueOf(maxString));
                    break;
                }
                case STRING: {
                    builder.setMinValue((Comparable)((Object)minString));
                    builder.setMaxValue((Comparable)((Object)maxString));
                    break;
                }
                case BYTES: {
                    builder.setMinValue((Comparable)BytesUtils.toByteArray((String)minString));
                    builder.setMaxValue((Comparable)BytesUtils.toByteArray((String)maxString));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + column);
                }
            }
        }
        if ((partitionFunctionName = config.getString(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionFunction"))) != null) {
            int numPartitions = config.getInt(V1Constants.MetadataKeys.Column.getKeyFor(column, "numPartitions"));
            PartitionFunction partitionFunction = PartitionFunctionFactory.getPartitionFunction(partitionFunctionName, numPartitions);
            builder.setPartitionFunction(partitionFunction);
            builder.setNumPartitions(numPartitions);
            builder.setPartitions(ColumnPartitionMetadata.extractPartitions((List)config.getList(V1Constants.MetadataKeys.Column.getKeyFor(column, "partitionValues"))));
        }
        return builder.build();
    }

    public PartitionFunction getPartitionFunction() {
        return this.partitionFunction;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public Set<Integer> getPartitions() {
        return this._partitions;
    }

    private ColumnMetadata(String columnName, int cardinality, int totalDocs, FieldSpec.DataType dataType, int bitsPerElement, int columnMaxLength, FieldSpec.FieldType fieldType, boolean isSorted, boolean hasNulls, boolean hasDictionary, boolean hasInvertedIndex, boolean isSingleValue, int maxNumberOfMultiValues, int totalNumberOfEntries, boolean isAutoGenerated, boolean isVirtual, String defaultNullValueString, TimeUnit timeUnit, char paddingCharacter, Comparable minValue, Comparable maxValue, PartitionFunction partitionFunction, int numPartitions, Set<Integer> partitions, String dateTimeFormat, String dateTimeGranularity, TextIndexType textIndexType) {
        this.columnName = columnName;
        this.cardinality = cardinality;
        this.totalDocs = totalDocs;
        this.dataType = dataType;
        this.bitsPerElement = bitsPerElement;
        this.columnMaxLength = columnMaxLength;
        this.fieldType = fieldType;
        this.isSorted = isSorted;
        this.containsNulls = hasNulls;
        this.hasDictionary = hasDictionary;
        this.hasInvertedIndex = hasInvertedIndex;
        this.isSingleValue = isSingleValue;
        this.maxNumberOfMultiValues = maxNumberOfMultiValues;
        this.totalNumberOfEntries = totalNumberOfEntries;
        this.isAutoGenerated = isAutoGenerated;
        this.isVirtual = isVirtual;
        this.defaultNullValueString = defaultNullValueString;
        this.timeUnit = timeUnit;
        this.paddingCharacter = paddingCharacter;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.partitionFunction = partitionFunction;
        this.numPartitions = numPartitions;
        this._partitions = partitions;
        this.dateTimeFormat = dateTimeFormat;
        this.dateTimeGranularity = dateTimeGranularity;
        this.textIndexType = textIndexType;
        switch (fieldType) {
            case DIMENSION: {
                this.fieldSpec = new DimensionFieldSpec(columnName, dataType, isSingleValue);
                break;
            }
            case METRIC: {
                this.fieldSpec = new MetricFieldSpec(columnName, dataType);
                break;
            }
            case TIME: {
                this.fieldSpec = new TimeFieldSpec(new TimeGranularitySpec(dataType, timeUnit, columnName));
                break;
            }
            case DATE_TIME: {
                this.fieldSpec = new DateTimeFieldSpec(columnName, dataType, dateTimeFormat, dateTimeGranularity);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported field type: " + fieldType);
            }
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getTotalDocs() {
        return this.totalDocs;
    }

    public FieldSpec.DataType getDataType() {
        return this.dataType;
    }

    public int getBitsPerElement() {
        return this.bitsPerElement;
    }

    public int getColumnMaxLength() {
        return this.columnMaxLength;
    }

    public FieldSpec.FieldType getFieldType() {
        return this.fieldType;
    }

    public boolean isSorted() {
        return this.isSorted;
    }

    public boolean hasNulls() {
        return this.containsNulls;
    }

    public boolean hasDictionary() {
        return this.hasDictionary;
    }

    public boolean hasInvertedIndex() {
        return this.hasInvertedIndex;
    }

    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    public int getMaxNumberOfMultiValues() {
        return this.maxNumberOfMultiValues;
    }

    public int getTotalNumberOfEntries() {
        return this.totalNumberOfEntries;
    }

    public boolean isAutoGenerated() {
        return this.isAutoGenerated;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public String getDefaultNullValueString() {
        return this.defaultNullValueString;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public char getPaddingCharacter() {
        return this.paddingCharacter;
    }

    public FieldSpec getFieldSpec() {
        return this.fieldSpec;
    }

    public Comparable getMinValue() {
        return this.minValue;
    }

    public Comparable getMaxValue() {
        return this.maxValue;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getDateTimeGranularity() {
        return this.dateTimeGranularity;
    }

    public TextIndexType getTextIndexType() {
        return this.textIndexType;
    }

    public String toString() {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        result.append(this.getClass().getName());
        result.append(" Object {");
        result.append(newLine);
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            result.append("  ");
            try {
                result.append(field.getName());
                result.append(": ");
                result.append(field.get(this));
            }
            catch (IllegalAccessException ex) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Unable to access field " + field, (Throwable)ex);
                }
                result.append("[ERROR]");
            }
            result.append(newLine);
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ColumnMetadata) {
            ColumnMetadata columnMetadata = (ColumnMetadata)object;
            return this.getColumnName() == columnMetadata.getColumnName() && this.getCardinality() == columnMetadata.getCardinality() && this.getTotalDocs() == columnMetadata.getTotalDocs() && this.getDataType().equals((Object)columnMetadata.getDataType()) && this.getBitsPerElement() == columnMetadata.getBitsPerElement() && this.getFieldSpec().equals((Object)columnMetadata.getFieldSpec()) && this.isSorted() == columnMetadata.isSorted() && this.hasNulls() == columnMetadata.hasNulls() && this.hasDictionary() == columnMetadata.hasDictionary() && this.hasInvertedIndex() == columnMetadata.hasInvertedIndex() && this.isSingleValue() == columnMetadata.isSingleValue() && this.isVirtual() == columnMetadata.isVirtual() && this.getMaxNumberOfMultiValues() == columnMetadata.getMaxNumberOfMultiValues() && this.getTotalNumberOfEntries() == columnMetadata.getTotalNumberOfEntries() && this.isAutoGenerated() == columnMetadata.isAutoGenerated() && this.getDefaultNullValueString() == columnMetadata.getDefaultNullValueString() && this.getTimeUnit() == columnMetadata.getTimeUnit() && this.getPaddingCharacter() == columnMetadata.getPaddingCharacter() && this.minValue == columnMetadata.getMinValue() && this.maxValue == columnMetadata.getMaxValue() && this.getPartitionFunction() == columnMetadata.getPartitionFunction() && this.getNumPartitions() == columnMetadata.getNumPartitions() && this.getPartitions() == columnMetadata.getPartitions() && this.getDateTimeFormat() == columnMetadata.getDateTimeFormat() && this.getDateTimeGranularity() == columnMetadata.getDateTimeGranularity() && this.getTextIndexType().equals((Object)columnMetadata.getTextIndexType());
        }
        return false;
    }

    public static class Builder {
        private String columnName;
        private int cardinality;
        private int totalDocs;
        private FieldSpec.DataType dataType;
        private int bitsPerElement;
        private int columnMaxLength;
        private FieldSpec.FieldType fieldType;
        private boolean isSorted;
        private boolean containsNulls;
        private boolean hasDictionary;
        private boolean hasInvertedIndex;
        private boolean isSingleValue;
        private boolean isVirtual;
        private int maxNumberOfMultiValues;
        private int totalNumberOfEntries;
        private boolean isAutoGenerated;
        private String defaultNullValueString;
        private TimeUnit timeUnit;
        private char paddingCharacter;
        private Comparable minValue;
        private Comparable maxValue;
        private PartitionFunction partitionFunction;
        private int numPartitions;
        private Set<Integer> _partitions;
        private String dateTimeFormat;
        private String dateTimeGranularity;
        private String textIndexType = TextIndexType.NONE.name();

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setCardinality(int cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        public Builder setTotalDocs(int totalDocs) {
            this.totalDocs = totalDocs;
            return this;
        }

        public Builder setDataType(FieldSpec.DataType dataType) {
            this.dataType = dataType.getStoredType();
            return this;
        }

        public Builder setBitsPerElement(int bitsPerElement) {
            this.bitsPerElement = bitsPerElement;
            return this;
        }

        public Builder setColumnMaxLength(int columnMaxLength) {
            this.columnMaxLength = columnMaxLength;
            return this;
        }

        public Builder setFieldType(FieldSpec.FieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public Builder setIsSorted(boolean isSorted) {
            this.isSorted = isSorted;
            return this;
        }

        public Builder setContainsNulls(boolean containsNulls) {
            this.containsNulls = containsNulls;
            return this;
        }

        public Builder setHasDictionary(boolean hasDictionary) {
            this.hasDictionary = hasDictionary;
            return this;
        }

        public Builder setHasInvertedIndex(boolean hasInvertedIndex) {
            this.hasInvertedIndex = hasInvertedIndex;
            return this;
        }

        public Builder setSingleValue(boolean singleValue) {
            this.isSingleValue = singleValue;
            return this;
        }

        public Builder setMaxNumberOfMultiValues(int maxNumberOfMultiValues) {
            this.maxNumberOfMultiValues = maxNumberOfMultiValues;
            return this;
        }

        public Builder setTotalNumberOfEntries(int totalNumberOfEntries) {
            this.totalNumberOfEntries = totalNumberOfEntries;
            return this;
        }

        public Builder setAutoGenerated(boolean isAutoGenerated) {
            this.isAutoGenerated = isAutoGenerated;
            return this;
        }

        public Builder setVirtual(boolean isVirtual) {
            this.isVirtual = isVirtual;
            return this;
        }

        public Builder setDefaultNullValueString(String defaultNullValueString) {
            this.defaultNullValueString = defaultNullValueString;
            return this;
        }

        public Builder setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder setPaddingCharacter(char paddingCharacter) {
            this.paddingCharacter = paddingCharacter;
            return this;
        }

        public Builder setMinValue(Comparable minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder setMaxValue(Comparable maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder setPartitionFunction(PartitionFunction partitionFunction) {
            this.partitionFunction = partitionFunction;
            return this;
        }

        public void setNumPartitions(int numPartitions) {
            this.numPartitions = numPartitions;
        }

        public Builder setPartitions(Set<Integer> partitions) {
            this._partitions = partitions;
            return this;
        }

        public Builder setDateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder setDateTimeGranularity(String dateTimeGranularity) {
            this.dateTimeGranularity = dateTimeGranularity;
            return this;
        }

        public Builder setTextIndexType(String textIndexType) {
            this.textIndexType = textIndexType;
            return this;
        }

        public ColumnMetadata build() {
            return new ColumnMetadata(this.columnName, this.cardinality, this.totalDocs, this.dataType, this.bitsPerElement, this.columnMaxLength, this.fieldType, this.isSorted, this.containsNulls, this.hasDictionary, this.hasInvertedIndex, this.isSingleValue, this.maxNumberOfMultiValues, this.totalNumberOfEntries, this.isAutoGenerated, this.isVirtual, this.defaultNullValueString, this.timeUnit, this.paddingCharacter, this.minValue, this.maxValue, this.partitionFunction, this.numPartitions, this._partitions, this.dateTimeFormat, this.dateTimeGranularity, TextIndexType.valueOf(this.textIndexType));
        }
    }
}

