/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.indexsegment.generator.SegmentVersion;
import org.apache.pinot.core.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.core.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.core.segment.index.loader.LoaderUtils;
import org.apache.pinot.core.segment.index.metadata.ColumnMetadata;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.core.segment.index.readers.ForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.core.segment.index.readers.forward.FixedBitSVForwardIndexReader;
import org.apache.pinot.core.segment.memory.PinotDataBuffer;
import org.apache.pinot.core.segment.store.ColumnIndexType;
import org.apache.pinot.core.segment.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvertedIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvertedIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _invertedIndexColumns = new HashSet<ColumnMetadata>();

    public InvertedIndexHandler(File indexDir, SegmentMetadataImpl segmentMetadata, IndexLoadingConfig indexLoadingConfig, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = SegmentVersion.valueOf(segmentMetadata.getVersion());
        for (String column : indexLoadingConfig.getInvertedIndexColumns()) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null || columnMetadata.isSorted() || !columnMetadata.hasDictionary()) continue;
            this._invertedIndexColumns.add(columnMetadata);
        }
    }

    public void createInvertedIndices() throws IOException {
        for (ColumnMetadata columnMetadata : this._invertedIndexColumns) {
            this.createInvertedIndexForColumn(columnMetadata);
        }
    }

    private void createInvertedIndexForColumn(ColumnMetadata columnMetadata) throws IOException {
        String column = columnMetadata.getColumnName();
        File inProgress = new File(this._indexDir, column + ".inv.inprogress");
        File invertedIndexFile = new File(this._indexDir, column + ".bitmap.inv");
        if (!inProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(column, ColumnIndexType.INVERTED_INDEX)) {
                LOGGER.info("Found inverted index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
                return;
            }
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)invertedIndexFile);
        }
        LOGGER.info("Creating new inverted index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
        int numDocs = columnMetadata.getTotalDocs();
        try (OffHeapBitmapInvertedIndexCreator creator = new OffHeapBitmapInvertedIndexCreator(this._indexDir, columnMetadata.getFieldSpec(), columnMetadata.getCardinality(), numDocs, columnMetadata.getTotalNumberOfEntries());
             ForwardIndexReader<?> forwardIndexReader = this.getForwardIndexReader(columnMetadata, this._segmentWriter);
             Object readerContext = forwardIndexReader.createContext();){
            if (columnMetadata.isSingleValue()) {
                for (int i = 0; i < numDocs; ++i) {
                    creator.add(forwardIndexReader.getDictId(i, readerContext));
                }
            } else {
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                    creator.add(dictIds, length);
                }
            }
            creator.seal();
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, invertedIndexFile, ColumnIndexType.INVERTED_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created inverted index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
    }

    private ForwardIndexReader<?> getForwardIndexReader(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter) throws IOException {
        PinotDataBuffer buffer = segmentWriter.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.FORWARD_INDEX);
        int numRows = columnMetadata.getTotalDocs();
        int numBitsPerValue = columnMetadata.getBitsPerElement();
        if (columnMetadata.isSingleValue()) {
            return new FixedBitSVForwardIndexReader(buffer, numRows, numBitsPerValue);
        }
        return new FixedBitMVForwardIndexReader(buffer, numRows, columnMetadata.getTotalNumberOfEntries(), numBitsPerValue);
    }
}

